/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.responses.RdfSerializationUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RdfSerializationUtilsTest {
    private final UriInfo info = (UriInfo)Mockito.mock(UriInfo.class);
    private final Dataset testData = new DatasetImpl(ModelFactory.createDefaultModel());
    private PathSegment segment;

    @Before
    public void setup() {
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), NodeFactory.createURI((String)"test:predicate"), NodeFactory.createLiteral((String)"test:object")));
        ArrayList<PathSegment> segments = new ArrayList<PathSegment>();
        this.segment = (PathSegment)Mockito.mock(PathSegment.class);
        segments.add(this.segment);
        Mockito.when((Object)this.info.getPathSegments()).thenReturn(segments);
    }

    @Test
    public void testGetFirstValueForPredicate() {
        String foundValue = RdfSerializationUtils.getFirstValueForPredicate((Dataset)this.testData, (Node)Node.ANY, (Node)NodeFactory.createURI((String)"test:predicate"));
        Assert.assertEquals((String)"Didn't find correct value for predicate!", (Object)foundValue, (Object)"test:object");
    }

    @Test
    public void testSetCachingHeaders() {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        Mockito.when((Object)this.segment.getPath()).thenReturn((Object)"/fedora");
        RdfSerializationUtils.setCachingHeaders((MultivaluedMap)headers, (Dataset)this.testData, (UriInfo)this.info);
        List cacheControlHeaders = (List)headers.get((Object)"Cache-Control");
        Assert.assertEquals((String)"Two cache control headers expected: ", (long)2L, (long)cacheControlHeaders.size());
        Assert.assertEquals((String)"max-age=0 expected", (Object)"max-age=0", cacheControlHeaders.get(0));
        Assert.assertEquals((String)"must-revalidate expected", (Object)"must-revalidate", cacheControlHeaders.get(1));
    }

    @Test
    public void testSetNoLastModifiedHeaderWithinTransaction() {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        Model m = ModelFactory.createDefaultModel();
        Calendar c = Calendar.getInstance();
        m.add(m.createResource("test:subject"), m.createProperty(RdfSerializationUtils.lastModifiedPredicate.getURI()), (RDFNode)m.createTypedLiteral(c));
        Dataset testDatasetWithLastModified = DatasetFactory.create((Model)m);
        Context context = testDatasetWithLastModified.getContext();
        context.set(Symbol.create((String)"uri"), (Object)"test:subject");
        Mockito.when((Object)this.segment.getPath()).thenReturn((Object)"tx:abc");
        RdfSerializationUtils.setCachingHeaders((MultivaluedMap)headers, (Dataset)testDatasetWithLastModified, (UriInfo)this.info);
        Assert.assertNull((String)"No Last-Modified header expected during transaction", (Object)headers.get((Object)"Last-Modified"));
    }

    @Test
    public void testSetCachingHeadersWithLastModified() {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        Model m = ModelFactory.createDefaultModel();
        Calendar c = Calendar.getInstance();
        m.add(m.createResource("test:subject"), m.createProperty(RdfSerializationUtils.lastModifiedPredicate.getURI()), (RDFNode)m.createTypedLiteral(c));
        Dataset testDatasetWithLastModified = DatasetFactory.create((Model)m);
        Context context = testDatasetWithLastModified.getContext();
        context.set(Symbol.create((String)"uri"), (Object)"test:subject");
        Mockito.when((Object)this.segment.getPath()).thenReturn((Object)"/fedora");
        RdfSerializationUtils.setCachingHeaders((MultivaluedMap)headers, (Dataset)testDatasetWithLastModified, (UriInfo)this.info);
        Assert.assertTrue((boolean)new DateTime((Object)c).withMillisOfSecond(0).isEqual((ReadableInstant)RdfSerializationUtils.RFC2822DATEFORMAT.parseDateTime((String)((List)headers.get((Object)"Last-Modified")).get(0))));
    }
}

