/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import java.util.regex.Pattern;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LockExceptionMapper
implements ExceptionMapper<LockException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockExceptionMapper.class);

    public Response toResponse(LockException exception) {
        LOGGER.debug("LockExceptionMapper intercepted exception: \n", (Throwable)exception);
        if (exception.getMessage() != null && Pattern.matches("^\\QThe lock token '\\E.*'\\Q is not valid\\E$", exception.getMessage())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)exception.getMessage()).build();
    }
}

