/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.fcrepo.http.commons.domain.ContentLocationMessageBodyReader;
import org.fcrepo.kernel.services.ExternalContentService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ContentLocationMessageBodyReaderTest {
    private ContentLocationMessageBodyReader testObj;
    @Mock
    private InputStream mockInputStream;
    @Mock
    private ExternalContentService mockContentService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new ContentLocationMessageBodyReader();
        this.testObj.setContentService(this.mockContentService);
    }

    @Test
    public void testReadFromURI() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.putSingle((Object)"Content-Location", (Object)"http://localhost:8080/xyz");
        Mockito.when((Object)this.mockContentService.retrieveExternalContent(new URI("http://localhost:8080/xyz"))).thenReturn((Object)this.mockInputStream);
        try (InputStream actual = this.testObj.readFrom(InputStream.class, null, null, null, (MultivaluedMap)headers, null);){
            Assert.assertEquals((Object)this.mockInputStream, (Object)actual);
        }
    }

    @Test
    public void testReadFromRequestBody() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        try (InputStream actual = this.testObj.readFrom(InputStream.class, null, null, null, (MultivaluedMap)headers, this.mockInputStream);){
            Assert.assertEquals((Object)this.mockInputStream, (Object)actual);
        }
    }
}

