/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.test.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.kernel.impl.identifiers.UUIDPidMinter;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.fcrepo.kernel.utils.ContentDigest;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.api.Repository;
import org.modeshape.jcr.api.Session;
import org.modeshape.jcr.api.query.QueryManager;

public abstract class TestHelpers {
    public static String MOCK_PREFIX = "mockPrefix";
    public static String MOCK_URI_STRING = "mock.namespace.org";

    public static UriInfo getUriInfoImpl() {
        UriInfo ui = (UriInfo)Mockito.mock(UriInfo.class);
        Answer<UriBuilder> answer = new Answer<UriBuilder>(){

            public UriBuilder answer(InvocationOnMock invocation) {
                return UriBuilder.fromUri((String)"http://localhost/fcrepo");
            }
        };
        Mockito.when((Object)ui.getRequestUri()).thenReturn((Object)URI.create("http://localhost/fcrepo"));
        Mockito.when((Object)ui.getBaseUri()).thenReturn((Object)URI.create("http://localhost/fcrepo"));
        Mockito.when((Object)ui.getBaseUriBuilder()).thenAnswer((Answer)answer);
        Mockito.when((Object)ui.getAbsolutePathBuilder()).thenAnswer((Answer)answer);
        return ui;
    }

    public static javax.jcr.Session getQuerySessionMock() {
        javax.jcr.Session mock = (javax.jcr.Session)Mockito.mock(javax.jcr.Session.class);
        Workspace mockWS = (Workspace)Mockito.mock(Workspace.class);
        QueryManager mockQM = (QueryManager)Mockito.mock(QueryManager.class);
        try {
            Query mockQ = TestHelpers.getQueryMock();
            Mockito.when((Object)mockQM.createQuery(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)((org.modeshape.jcr.api.query.Query)mockQ));
            Mockito.when((Object)mockWS.getQueryManager()).thenReturn((Object)mockQM);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        Mockito.when((Object)mock.getWorkspace()).thenReturn((Object)mockWS);
        ValueFactory mockVF = (ValueFactory)Mockito.mock(ValueFactory.class);
        try {
            Mockito.when((Object)mock.getValueFactory()).thenReturn((Object)mockVF);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return mock;
    }

    public static Query getQueryMock() {
        Query mockQ = (Query)Mockito.mock(Query.class);
        QueryResult mockResults = (QueryResult)Mockito.mock(QueryResult.class);
        NodeIterator mockNodes = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)mockNodes.getSize()).thenReturn((Object)2L);
        Mockito.when((Object)mockNodes.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        try {
            Mockito.when((Object)node1.getName()).thenReturn((Object)"node1");
            Mockito.when((Object)node2.getName()).thenReturn((Object)"node2");
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        Mockito.when((Object)mockNodes.nextNode()).thenReturn((Object)node1, (Object[])new Node[]{node2}).thenThrow(new Class[]{IndexOutOfBoundsException.class});
        try {
            Mockito.when((Object)mockResults.getNodes()).thenReturn((Object)mockNodes);
            Mockito.when((Object)mockQ.execute()).thenReturn((Object)mockResults);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return mockQ;
    }

    public static javax.jcr.Session getSessionMock() throws RepositoryException {
        String[] mockPrefixes = new String[]{MOCK_PREFIX};
        javax.jcr.Session mockSession = (javax.jcr.Session)Mockito.mock(javax.jcr.Session.class);
        Workspace mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        NamespaceRegistry mockNameReg = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        NodeTypeManager mockNTM = (NodeTypeManager)Mockito.mock(NodeTypeManager.class);
        NodeTypeIterator mockNTI = (NodeTypeIterator)Mockito.mock(NodeTypeIterator.class);
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockSession.getWorkspace()).thenReturn((Object)mockWorkspace);
        Mockito.when((Object)mockWorkspace.getNamespaceRegistry()).thenReturn((Object)mockNameReg);
        Mockito.when((Object)mockNameReg.getPrefixes()).thenReturn((Object)mockPrefixes);
        Mockito.when((Object)mockNameReg.getURI(MOCK_PREFIX)).thenReturn((Object)MOCK_URI_STRING);
        Mockito.when((Object)mockWorkspace.getNodeTypeManager()).thenReturn((Object)mockNTM);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"mockName");
        Mockito.when((Object)mockNodeType.toString()).thenReturn((Object)"mockString");
        Mockito.when((Object)mockNTM.getAllNodeTypes()).thenReturn((Object)mockNTI);
        Mockito.when((Object)mockNTI.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockNTI.nextNodeType()).thenReturn((Object)mockNodeType).thenThrow(new Class[]{ArrayIndexOutOfBoundsException.class});
        return mockSession;
    }

    public static Collection<String> parseChildren(HttpEntity entity) throws IOException {
        String body = EntityUtils.toString((HttpEntity)entity);
        System.err.println(body);
        String[] names = body.replace("[", "").replace("]", "").trim().split(",\\s?");
        return Arrays.asList(names);
    }

    public static javax.jcr.Session mockSession(AbstractResource testObj) {
        SecurityContext mockSecurityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Principal mockPrincipal = (Principal)Mockito.mock(Principal.class);
        String mockUser = "testuser";
        javax.jcr.Session mockSession = (javax.jcr.Session)Mockito.mock(javax.jcr.Session.class);
        Mockito.when((Object)mockSession.getUserID()).thenReturn((Object)"testuser");
        Mockito.when((Object)mockSecurityContext.getUserPrincipal()).thenReturn((Object)mockPrincipal);
        Mockito.when((Object)mockPrincipal.getName()).thenReturn((Object)"testuser");
        Workspace mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)mockSession.getWorkspace()).thenReturn((Object)mockWorkspace);
        Mockito.when((Object)mockWorkspace.getName()).thenReturn((Object)"default");
        TestHelpers.setField(testObj, "uriInfo", TestHelpers.getUriInfoImpl());
        TestHelpers.setField(testObj, "pidMinter", new UUIDPidMinter());
        return mockSession;
    }

    public static Repository mockRepository() throws LoginException, RepositoryException {
        Repository mockRepo = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)mockRepo.login()).thenReturn(Mockito.mock(Session.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{javax.jcr.Session.class})));
        return mockRepo;
    }

    public static NonRdfSourceDescription mockDatastream(String pid, String dsId, String content) {
        FedoraBinary mockBinary = TestHelpers.mockBinary(pid, dsId, content);
        NonRdfSourceDescription mockDs = (NonRdfSourceDescription)Mockito.mock(NonRdfSourceDescription.class);
        Mockito.when((Object)mockDs.getDescribedResource()).thenReturn((Object)mockBinary);
        Mockito.when((Object)mockDs.getDescribedResource().getDescription()).thenReturn((Object)mockDs);
        Mockito.when((Object)mockDs.getPath()).thenReturn((Object)("/" + pid + "/" + dsId));
        Mockito.when((Object)mockDs.getCreatedDate()).thenReturn((Object)new Date());
        Mockito.when((Object)mockDs.getLastModifiedDate()).thenReturn((Object)new Date());
        if (content != null) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            byte[] digest = md.digest(content.getBytes());
            URI cd = ContentDigest.asURI((String)"SHA-1", (byte[])digest);
            Mockito.when((Object)mockDs.getEtagValue()).thenReturn((Object)cd.toString());
        }
        return mockDs;
    }

    public static FedoraBinary mockBinary(String pid, String dsId, String content) {
        FedoraBinary mockBinary = (FedoraBinary)Mockito.mock(FedoraBinary.class);
        Mockito.when((Object)mockBinary.getPath()).thenReturn((Object)("/" + pid + "/" + dsId + "/jcr:content"));
        Mockito.when((Object)mockBinary.getMimeType()).thenReturn((Object)"application/octet-stream");
        Mockito.when((Object)mockBinary.getCreatedDate()).thenReturn((Object)new Date());
        Mockito.when((Object)mockBinary.getLastModifiedDate()).thenReturn((Object)new Date());
        if (content != null) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            byte[] digest = md.digest(content.getBytes());
            URI cd = ContentDigest.asURI((String)"SHA-1", (byte[])digest);
            Mockito.when((Object)mockBinary.getContent()).thenReturn((Object)IOUtils.toInputStream((String)content));
            Mockito.when((Object)mockBinary.getContentDigest()).thenReturn((Object)cd);
            Mockito.when((Object)mockBinary.getEtagValue()).thenReturn((Object)cd.toString());
        }
        return mockBinary;
    }

    private static String getRdfSerialization(HttpEntity entity) {
        MediaType mediaType = MediaType.valueOf((String)entity.getContentType().getValue());
        Lang lang = RDFLanguages.contentTypeToLang((String)mediaType.toString());
        Assert.assertNotNull((String)"Entity is not an RDF serialization", (Object)lang);
        return lang.getName();
    }

    public static GraphStore parseTriples(HttpEntity entity) throws IOException {
        return TestHelpers.parseTriples(entity.getContent(), TestHelpers.getRdfSerialization(entity));
    }

    public static GraphStore parseTriples(InputStream content) {
        return TestHelpers.parseTriples(content, "N3");
    }

    public static GraphStore parseTriples(InputStream content, String contentType) {
        Model model = ModelFactory.createDefaultModel();
        model.read(content, "", contentType);
        return GraphStoreFactory.create((Model)model);
    }

    public static void setField(Object parent, String name, Object obj) {
        try {
            Field f = TestHelpers.findField(parent.getClass(), name);
            f.setAccessible(true);
            f.set(parent, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Field findField(Class<?> clazz, String name) throws NoSuchFieldException {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        if (clazz.getSuperclass() == null) {
            throw new NoSuchFieldException("Field " + name + " could not be found");
        }
        return TestHelpers.findField(clazz.getSuperclass(), name);
    }
}

