/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons;

import com.google.common.eventbus.EventBus;
import com.hp.hpl.jena.rdf.model.Resource;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.identifiers.PidMinter;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.services.BinaryService;
import org.fcrepo.kernel.services.ContainerService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.VersionService;
import org.jvnet.hk2.annotations.Optional;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResource {
    @Context
    protected UriInfo uriInfo;
    @Autowired
    protected SessionFactory sessions;
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected ContainerService containerService;
    @Autowired
    protected BinaryService binaryService;
    @Autowired
    protected VersionService versionService;
    @Inject
    @Optional
    protected EventBus eventBus;
    @Autowired
    protected PidMinter pidMinter;

    public static final String toPath(IdentifierConverter<Resource, FedoraResource> idTranslator, String originalPath) {
        Resource resource = (Resource)idTranslator.toDomain(originalPath);
        String path = idTranslator.asString((Object)resource);
        if (path.isEmpty()) {
            return "/";
        }
        return path;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

