/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.jersey.message.internal.HttpHeaderReader;

public class PreferTag
implements Comparable<PreferTag> {
    private final String tag;
    private String value = "";
    private Map<String, String> params = new HashMap<String, String>();

    public static PreferTag emptyTag() {
        try {
            return new PreferTag((String)null);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    public PreferTag(PreferTag preferTag) {
        this.tag = preferTag.getTag();
        this.value = preferTag.getValue();
        this.params = preferTag.getParams();
    }

    public PreferTag(HttpHeaderReader reader) throws ParseException {
        reader.hasNext();
        if (reader.hasNext()) {
            this.tag = reader.nextToken();
            if (reader.hasNextSeparator('=', true)) {
                reader.next();
                this.value = reader.nextTokenOrQuotedString();
            }
            if (reader.hasNext()) {
                this.params = HttpHeaderReader.readParameters((HttpHeaderReader)reader);
            }
        } else {
            this.tag = "";
        }
    }

    public PreferTag(String inputTag) throws ParseException {
        this(HttpHeaderReader.newInstance((String)inputTag));
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void addResponseHeaders(HttpServletResponse servletResponse) {
        if (!this.value.equals("minimal")) {
            servletResponse.addHeader("Preference-Applied", "return=representation");
        } else {
            servletResponse.addHeader("Preference-Applied", "return=minimal");
        }
        servletResponse.addHeader("Vary", "Prefer");
    }

    @Override
    public int compareTo(PreferTag otherTag) {
        return this.getTag().compareTo(otherTag.getTag());
    }
}

