/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.ParseException;
import java.util.Set;
import java.util.TreeSet;
import org.fcrepo.http.commons.domain.PreferTag;
import org.glassfish.jersey.message.internal.HttpHeaderReader;

public class SinglePrefer {
    private final Set<PreferTag> preferTags = new TreeSet<PreferTag>();
    private static final HttpHeaderReader.ListElementCreator<PreferTag> PREFER_CREATOR = new HttpHeaderReader.ListElementCreator<PreferTag>(){

        public PreferTag create(HttpHeaderReader reader) throws ParseException {
            return new PreferTag(reader);
        }
    };

    public SinglePrefer(String header) throws ParseException {
        this.preferTags.addAll(HttpHeaderReader.readList(PREFER_CREATOR, (String)header));
    }

    public Boolean hasReturn() {
        return Iterables.any(this.preferTags(), SinglePrefer.getPreferTag("return"));
    }

    public Boolean hasHandling() {
        return Iterables.any(this.preferTags(), SinglePrefer.getPreferTag("handling"));
    }

    public PreferTag getReturn() {
        return (PreferTag)Iterables.tryFind(this.preferTags(), SinglePrefer.getPreferTag("return")).or((Object)PreferTag.emptyTag());
    }

    public PreferTag getHandling() {
        return (PreferTag)Iterables.tryFind(this.preferTags(), SinglePrefer.getPreferTag("handling")).or((Object)PreferTag.emptyTag());
    }

    private static <T extends PreferTag> Predicate<T> getPreferTag(final String tagName) {
        return new Predicate<T>(){

            public boolean apply(T tag) {
                return ((PreferTag)tag).getTag().equals(tagName);
            }
        };
    }

    protected Set<PreferTag> preferTags() {
        return this.preferTags;
    }
}

