/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain.ldp;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.List;
import org.fcrepo.http.commons.domain.PreferTag;
import org.fcrepo.kernel.RdfLexicon;

public class LdpPreferTag
extends PreferTag {
    private final boolean membership;
    private final boolean containment;
    private final boolean references;
    private final boolean preferMinimalContainer;
    private final boolean embed;
    private final boolean managedProperties;

    public LdpPreferTag(PreferTag preferTag) {
        super(preferTag);
        Optional include = Optional.fromNullable((Object)preferTag.getParams().get("include"));
        Optional omit = Optional.fromNullable((Object)preferTag.getParams().get("omit"));
        Optional received = Optional.fromNullable((Object)preferTag.getParams().get("received"));
        List<String> includes = Arrays.asList(((String)include.or((Object)" ")).split(" "));
        List<String> omits = Arrays.asList(((String)omit.or((Object)" ")).split(" "));
        boolean minimal = preferTag.getValue().equals("minimal") || ((String)received.or((Object)"")).equals("minimal");
        this.preferMinimalContainer = includes.contains("http://www.w3.org/ns/ldp#PreferMinimalContainer") || minimal;
        this.membership = !this.preferMinimalContainer && !omits.contains("http://www.w3.org/ns/ldp#PreferMembership") || includes.contains("http://www.w3.org/ns/ldp#PreferMembership");
        this.containment = !this.preferMinimalContainer && !omits.contains("http://www.w3.org/ns/ldp#PreferContainment") || includes.contains("http://www.w3.org/ns/ldp#PreferContainment");
        this.references = includes.contains(RdfLexicon.INBOUND_REFERENCES.toString());
        this.embed = includes.contains(RdfLexicon.EMBED_CONTAINS.toString());
        this.managedProperties = includes.contains(RdfLexicon.SERVER_MANAGED.toString()) || !omits.contains(RdfLexicon.SERVER_MANAGED.toString()) && !minimal;
    }

    public boolean prefersMembership() {
        return this.membership;
    }

    public boolean prefersContainment() {
        return this.containment;
    }

    public boolean prefersReferences() {
        return this.references;
    }

    public boolean prefersEmbed() {
        return this.embed;
    }

    public boolean prefersServerManaged() {
        return this.managedProperties;
    }
}

