/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Iterator;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfSerializationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfSerializationUtils.class);
    public static Node primaryTypePredicate = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0") + "primaryType"));
    public static Node mixinTypesPredicate = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0") + "mixinTypes"));
    private static final Function<RDFNode, String> stringConverter = new Function<RDFNode, String>(){

        public String apply(RDFNode statement) {
            return statement.asLiteral().getLexicalForm();
        }
    };

    private RdfSerializationUtils() {
    }

    public static String getFirstValueForPredicate(Model rdf, Node subject, Node predicate) {
        NodeIterator statements = rdf.listObjectsOfProperty(ResourceFactory.createResource((String)subject.getURI()), ResourceFactory.createProperty((String)predicate.getURI()));
        if (statements.hasNext()) {
            return statements.next().asLiteral().getLexicalForm();
        }
        LOGGER.trace("No value found for predicate: {}", (Object)predicate);
        return null;
    }

    public static Iterator<String> getAllValuesForPredicate(Model rdf, Node subject, Node predicate) {
        NodeIterator objects = rdf.listObjectsOfProperty(ResourceFactory.createResource((String)subject.getURI()), ResourceFactory.createProperty((String)predicate.getURI()));
        ImmutableList copy = ImmutableList.copyOf((Iterator)objects);
        return Iterables.transform((Iterable)copy, stringConverter).iterator();
    }
}

