/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.TripleOrdering;
import org.fcrepo.kernel.RdfLexicon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewHelpers.class);
    private static ViewHelpers instance = null;

    protected ViewHelpers() {
    }

    public static ViewHelpers getInstance() {
        if (instance == null) {
            instance = new ViewHelpers();
        }
        return instance;
    }

    public Iterator<Triple> getObjects(Graph graph, Node subject, Resource predicate) {
        return graph.find(subject, predicate.asNode(), Node.ANY);
    }

    public Iterator<Node> getVersions(Graph graph, Node subject) {
        return this.getOrderedVersions(graph, subject, (Resource)RdfLexicon.HAS_VERSION);
    }

    public Iterator<Node> getOrderedVersions(Graph graph, Node subject, Resource predicate) {
        Iterator<Triple> versions = this.getObjects(graph, subject, predicate);
        TreeMap<String, Node> map = new TreeMap<String, Node>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        while (versions.hasNext()) {
            String key;
            Triple triple = versions.next();
            String date = this.getVersionDate(graph, triple.getObject());
            String string = key = Strings.isNullOrEmpty((String)date) ? format.format(new Date()) : date;
            while (map.containsKey(key)) {
                key = key + "1";
            }
            map.put(key, triple.getObject());
        }
        return map.values().iterator();
    }

    public String getVersionSubjectUrl(UriInfo uriInfo, Node subject) {
        Map<String, String> breadcrumbs = this.getNodeBreadcrumbs(uriInfo, subject);
        String lastUrl = null;
        for (Map.Entry<String, String> entry : breadcrumbs.entrySet()) {
            if (entry.getValue().equals("fcr:versions")) {
                return lastUrl;
            }
            lastUrl = entry.getKey();
        }
        return null;
    }

    public String getVersionLabel(Graph graph, Node subject, String defaultValue) {
        Iterator<Triple> objects = this.getObjects(graph, subject, (Resource)RdfLexicon.HAS_VERSION_LABEL);
        if (objects.hasNext()) {
            return objects.next().getObject().getLiteralValue().toString();
        }
        return defaultValue;
    }

    public String getVersionDate(Graph graph, Node subject) {
        Iterator<Triple> objects = this.getObjects(graph, subject, (Resource)RdfLexicon.CREATED_DATE);
        if (objects.hasNext()) {
            return objects.next().getObject().getLiteralValue().toString();
        }
        return "";
    }

    public String getObjectTitle(Graph graph, Node subject) {
        Property[] properties;
        if (subject == null) {
            return "";
        }
        for (Property p : properties = new Property[]{RdfLexicon.RDFS_LABEL, RdfLexicon.DC_TITLE}) {
            Iterator<Triple> objects = this.getObjects(graph, subject, (Resource)p);
            if (!objects.hasNext()) continue;
            return objects.next().getObject().getLiteral().getLexicalForm();
        }
        if (subject.isURI()) {
            return subject.getURI();
        }
        if (subject.isBlank()) {
            return subject.getBlankNodeLabel();
        }
        return subject.toString();
    }

    public String getSerializationTitle(Graph graph, Node subject) {
        Property dcFormat = ResourceFactory.createProperty((String)"http://purl.org/dc/elements/1.1/format");
        Iterator<Triple> formatRDFs = this.getObjects(graph, subject, (Resource)dcFormat);
        if (formatRDFs.hasNext()) {
            return this.getObjectTitle(graph, formatRDFs.next().getObject());
        }
        return "";
    }

    public boolean isWritable(Graph graph, Node subject) {
        Iterator<Triple> it = this.getObjects(graph, subject, (Resource)RdfLexicon.WRITABLE);
        return it.hasNext() && it.next().getObject().getLiteralValue().toString().equals("true");
    }

    public boolean isFrozenNode(Graph graph, Node subject) {
        Iterator<Triple> objects = this.getObjects(graph, subject, (Resource)RdfLexicon.HAS_PRIMARY_TYPE);
        return objects.hasNext() && objects.next().getObject().getLiteralValue().toString().equals("nt:frozenNode");
    }

    public String getObjectsAsString(Graph graph, Node subject, Resource predicate, boolean uriAsLink) {
        Iterator<Triple> iterator = this.getObjects(graph, subject, predicate);
        if (iterator.hasNext()) {
            Node object = iterator.next().getObject();
            if (object.isLiteral()) {
                String s = object.getLiteralValue().toString();
                if (s.isEmpty()) {
                    return "<empty>";
                }
                return s;
            }
            if (uriAsLink) {
                return "&lt;<a href=\"" + object.getURI() + "\">" + object.getURI() + "</a>&gt;";
            }
            return object.getURI();
        }
        return "";
    }

    public Map<String, String> getNodeBreadcrumbs(UriInfo uriInfo, Node subject) {
        String topic = subject.getURI();
        LOGGER.trace("Generating breadcrumbs for subject {}", (Object)subject);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String baseUri = uriInfo.getBaseUri().toString();
        if (!topic.startsWith(baseUri)) {
            LOGGER.trace("Topic wasn't part of our base URI {}", (Object)baseUri);
            return builder.build();
        }
        String salientPath = topic.substring(baseUri.length());
        String[] split = salientPath.split("/");
        StringBuilder cumulativePath = new StringBuilder();
        for (String path : split) {
            if (path.isEmpty()) continue;
            cumulativePath.append(path);
            String uri = uriInfo.getBaseUriBuilder().path(cumulativePath.toString()).build(new Object[0]).toString();
            LOGGER.trace("Adding breadcrumb for path segment {} => {}", (Object)path, (Object)uri);
            builder.put((Object)uri, (Object)path);
            cumulativePath.append("/");
        }
        return builder.build();
    }

    public List<Triple> getSortedTriples(Model model, Iterator<Triple> it) {
        return Ordering.from((Comparator)new TripleOrdering((PrefixMapping)model)).sortedCopy((Iterable)ImmutableList.copyOf(it));
    }

    public String getNamespacePrefix(PrefixMapping mapping, String namespace, boolean compact) {
        String nsURIPrefix = mapping.getNsURIPrefix(namespace);
        if (nsURIPrefix == null) {
            if (compact) {
                int hashIdx = namespace.lastIndexOf(35);
                int split = hashIdx > 0 ? namespace.substring(0, hashIdx).lastIndexOf(47) : namespace.lastIndexOf(47);
                if (split > 0) {
                    return "..." + namespace.substring(split);
                }
                return namespace;
            }
            return namespace;
        }
        return nsURIPrefix + ":";
    }

    public String getPrefixPreamble(PrefixMapping mapping) {
        StringBuilder sb = new StringBuilder();
        Map nsPrefixMap = mapping.getNsPrefixMap();
        for (Map.Entry entry : nsPrefixMap.entrySet()) {
            sb.append("PREFIX " + (String)entry.getKey() + ": <" + (String)entry.getValue() + ">\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean isRdfResource(Graph graph, Node subject, String namespace, String resource) {
        ExtendedIterator it = graph.find(subject, ResourceFactory.createResource((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type").asNode(), ResourceFactory.createResource((String)(namespace + resource)).asNode());
        return it.hasNext();
    }

    public Node asNode(Resource r) {
        return r.asNode();
    }

    public Node asLiteralStringNode(String r) {
        return ResourceFactory.createPlainLiteral((String)r).asNode();
    }

    public int addOne(int i) {
        return i + 1;
    }

    public Property rdfType() {
        return RDF.type;
    }

    public Property rdfsDomain() {
        return RDFS.domain;
    }

    public Resource rdfsClass() {
        return RDFS.Class;
    }

    public Node getContentNode(Node subject) {
        return NodeFactory.createURI((String)subject.getURI().replace("fcr:metadata", ""));
    }

    public String parameterize(String source) {
        return source.toLowerCase().replaceAll("[^a-z0-9\\-_]+", "_");
    }
}

