/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.domain.ContentLocation;
import org.fcrepo.kernel.services.ExternalContentService;
import org.springframework.beans.factory.annotation.Autowired;

@Provider
public class ContentLocationMessageBodyReader
implements MessageBodyReader<InputStream> {
    private static final Predicate<Annotation> HAS_CONTENT_LOCATION_PREDICATE = new Predicate<Annotation>(){

        public boolean apply(Annotation annotation) {
            return annotation.annotationType().equals(ContentLocation.class);
        }
    };
    @Autowired
    private ExternalContentService contentService;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return InputStream.class.isAssignableFrom(type) && Iterables.any(Arrays.asList(annotations), HAS_CONTENT_LOCATION_PREDICATE);
    }

    public InputStream readFrom(Class<InputStream> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (httpHeaders.containsKey((Object)"Content-Location")) {
            String location = (String)httpHeaders.getFirst((Object)"Content-Location");
            try {
                return this.contentService.retrieveExternalContent(new URI(location));
            }
            catch (URISyntaxException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
        }
        return entityStream;
    }

    @VisibleForTesting
    protected void setContentService(ExternalContentService externalContentService) {
        this.contentService = externalContentService;
    }
}

