/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.responses.RdfStreamStreamingOutput;
import org.fcrepo.kernel.impl.rdf.impl.NamespaceRdfContext;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.ntriples.NTriplesWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"text/turtle", "text/rdf+n3", "text/n3", "application/rdf+xml", "application/n-triples", "application/xml", "text/plain", "application/x-turtle", "application/ld+json"})
public class RdfStreamProvider
implements MessageBodyWriter<RdfStream> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamProvider.class);

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        LOGGER.debug("Checking to see if we can serialize type: {} to mimeType: {}", (Object)type.getName(), (Object)mediaType.toString());
        if (!RdfStream.class.isAssignableFrom(type)) {
            return false;
        }
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) || mediaType.equals((Object)MediaType.APPLICATION_XHTML_XML_TYPE) || mediaType.getType().equals("application") && mediaType.getSubtype().equals("html")) {
            LOGGER.debug("Was asked for an HTML mimeType, returning false.");
            return false;
        }
        LOGGER.debug("Assuming that this is an attempt to retrieve RDF, returning true.");
        return true;
    }

    public long getSize(RdfStream t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(RdfStream rdfStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
        LOGGER.debug("Serializing an RdfStream to mimeType: {}", (Object)mediaType);
        try {
            if (rdfStream.namespaces().isEmpty()) {
                NamespaceRdfContext namespaceRdfContext = new NamespaceRdfContext(rdfStream.session());
                rdfStream.namespaces(namespaceRdfContext.namespaces());
            }
            RdfStreamStreamingOutput streamOutput = new RdfStreamStreamingOutput(rdfStream, mediaType);
            streamOutput.write(entityStream);
        }
        catch (RepositoryException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PostConstruct
    public void registerMimeTypes() {
        RDFWriterRegistry.getInstance().add((Object)new NTriplesWithCorrectMimeType());
    }

    public static class NTriplesWithCorrectMimeType
    extends NTriplesWriterFactory {
        private static final RDFFormat NTRIPLESWITHCORRECTMIMETYPE = new RDFFormat("N-Triples-with-correct-mimeType", "application/n-triples", Charset.forName("US-ASCII"), "nt", false, false);

        public RDFFormat getRDFFormat() {
            return NTRIPLESWITHCORRECTMIMETYPE;
        }
    }
}

