/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.AbstractFuture;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.Literals;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.WriterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfStreamStreamingOutput
extends AbstractFuture<Void>
implements StreamingOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamStreamingOutput.class);
    private static ValueFactory vfactory = ValueFactoryImpl.getInstance();
    private final RDFFormat format;
    private final RdfStream rdfStream;
    protected static final Function<? super Triple, Statement> toStatement = new Function<Triple, Statement>(){

        public Statement apply(Triple t) {
            Resource subject = RdfStreamStreamingOutput.getResourceForSubject(t.getSubject());
            URI predicate = vfactory.createURI(t.getPredicate().getURI());
            Value object = RdfStreamStreamingOutput.getValueForObject(t.getObject());
            return vfactory.createStatement(subject, predicate, object);
        }
    };

    public RdfStreamStreamingOutput(RdfStream rdfStream, MediaType mediaType) {
        RDFFormat format;
        if (LOGGER.isDebugEnabled()) {
            for (RDFFormat writeableFormats : RDFWriterRegistry.getInstance().getKeys()) {
                LOGGER.debug("Discovered RDF writer writeableFormats: {} with mimeTypes: {}", (Object)writeableFormats.getName(), (Object)Joiner.on((String)" ").join((Iterable)writeableFormats.getMIMETypes()));
            }
        }
        if ((format = Rio.getWriterFormatForMIMEType((String)mediaType.toString())) == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        this.format = format;
        LOGGER.debug("Setting up to serialize to: {}", (Object)format);
        this.rdfStream = rdfStream;
    }

    public void write(OutputStream output) {
        LOGGER.debug("Serializing RDF stream in: {}", (Object)this.format);
        try {
            this.write(this.asStatements(), output, this.format);
        }
        catch (RDFHandlerException e) {
            this.setException(e);
            LOGGER.debug("Error serializing RDF", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    private void write(Iterable<Statement> model, OutputStream output, RDFFormat dataFormat) throws RDFHandlerException {
        WriterConfig settings = new WriterConfig();
        RDFWriter writer = Rio.createWriter((RDFFormat)dataFormat, (OutputStream)output);
        writer.setWriterConfig(settings);
        for (Map.Entry<String, String> namespace : RdfStreamStreamingOutput.excludeProtectedNamespaces(this.rdfStream.namespaces())) {
            writer.handleNamespace(namespace.getKey(), namespace.getValue());
        }
        Rio.write(model, (RDFHandler)writer);
    }

    private static Iterable<Map.Entry<String, String>> excludeProtectedNamespaces(Map<String, String> namespaces) {
        return Iterables.filter(namespaces.entrySet(), (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> input) {
                return !input.getKey().equals("xmlns");
            }
        });
    }

    private Iterable<Statement> asStatements() {
        return new Iterable<Statement>(){

            @Override
            public Iterator<Statement> iterator() {
                return RdfStreamStreamingOutput.this.rdfStream.transform(toStatement);
            }
        };
    }

    private static Resource getResourceForSubject(Node subjectNode) {
        Object subject = subjectNode.isBlank() ? vfactory.createBNode(subjectNode.getBlankNodeLabel()) : vfactory.createURI(subjectNode.getURI());
        return subject;
    }

    protected static Value getValueForObject(Node object) {
        URI value;
        if (object.isURI()) {
            value = vfactory.createURI(object.getURI());
        } else if (object.isBlank()) {
            value = vfactory.createBNode(object.getBlankNodeLabel());
        } else if (object.isLiteral()) {
            String literalValue = object.getLiteralLexicalForm();
            String literalDatatypeURI = object.getLiteralDatatypeURI();
            if (!object.getLiteralLanguage().isEmpty()) {
                value = vfactory.createLiteral(literalValue, object.getLiteralLanguage());
            } else if (literalDatatypeURI != null) {
                URI uri = vfactory.createURI(literalDatatypeURI);
                value = vfactory.createLiteral(literalValue, uri);
            } else {
                value = Literals.createLiteral((ValueFactory)vfactory, (Object)object.getLiteralValue());
            }
        } else {
            throw new AssertionError((Object)("Unable to convert " + object + " to a value"));
        }
        return value;
    }
}

