/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import javax.ws.rs.core.UriBuilder;
import org.fcrepo.http.commons.api.rdf.HttpResourceConverter;
import org.fcrepo.kernel.TxSession;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.FedoraBinaryImpl;
import org.fcrepo.kernel.impl.FedoraResourceImpl;
import org.fcrepo.kernel.impl.NonRdfSourceDescriptionImpl;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class HttpResourceConverterTest {
    @Mock
    private Session session;
    @Mock
    private TxSession txSession;
    @Mock
    private Node node;
    @Mock
    private Node versionedNode;
    @Mock
    private Node contentNode;
    @Mock
    private Property mockProperty;
    private HttpResourceConverter converter;
    private final String uriTemplate = "http://localhost:8080/some/{path: .*}";
    private final String path = "arbitrary/path";
    private final Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path");
    private final Resource versionedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:versions/x");
    private final Resource metadataResource = ResourceFactory.createResource((String)(this.resource.toString() + "/fcr:metadata"));
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private VersionManager mockVersionManager;
    @Mock
    private VersionHistory mockVersionHistory;
    @Mock
    private Version mockVersion;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)"http://localhost:8080/some/{path: .*}");
        this.converter = new HttpResourceConverter(this.session, uriBuilder);
        Mockito.when((Object)this.session.getNode("/arbitrary/path")).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.getPath()).thenReturn((Object)"/arbitrary/path");
        Mockito.when((Object)this.node.isNodeType("nt:frozenNode")).thenReturn((Object)false);
        Mockito.when((Object)this.node.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)false);
        Mockito.when((Object)this.contentNode.getPath()).thenReturn((Object)"/arbitrary/path/jcr:content");
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)this.mockVersionManager);
        Mockito.when((Object)this.versionedNode.isNodeType("nt:frozenNode")).thenReturn((Object)true);
    }

    @Test
    public void testDoForward() {
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)this.resource);
        Assert.assertEquals((Object)this.node, (Object)converted.getNode());
    }

    @Test
    public void testDoForwardWithDatastreamContent() throws Exception {
        Mockito.when((Object)this.node.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)true);
        Mockito.when((Object)this.node.getNode("jcr:content")).thenReturn((Object)this.contentNode);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)this.resource);
        Assert.assertTrue((boolean)(converted instanceof FedoraBinary));
        Assert.assertEquals((Object)this.contentNode, (Object)converted.getNode());
    }

    @Test
    public void testDoForwardWithDatastreamMetadata() throws Exception {
        Mockito.when((Object)this.node.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)true);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)this.metadataResource);
        Assert.assertTrue((boolean)(converted instanceof NonRdfSourceDescription));
        Assert.assertEquals((Object)this.node, (Object)converted.getNode());
    }

    @Test
    public void testDoForwardWithAHash() throws Exception {
        Mockito.when((Object)this.session.getNode("/arbitrary/path/#/with-a-hash")).thenReturn((Object)this.node);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path#with-a-hash"));
        Assert.assertEquals((Object)this.node, (Object)converted.getNode());
    }

    @Test
    public void testDoForwardWithTransaction() throws Exception {
        HttpResourceConverter converter = new HttpResourceConverter((Session)this.txSession, UriBuilder.fromUri((String)"http://localhost:8080/some/{path: .*}"));
        Mockito.when((Object)this.txSession.getTxId()).thenReturn((Object)"xyz");
        Mockito.when((Object)this.txSession.getNode("/arbitrary/path")).thenReturn((Object)this.node);
        Mockito.when((Object)this.txSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/tx:xyz/arbitrary/path");
        FedoraResource converted = (FedoraResource)converter.convert((Object)resource);
        Assert.assertEquals((Object)this.node, (Object)converted.getNode());
    }

    @Test
    public void testDoForwardWithUuid() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/[xyz]");
        Mockito.when((Object)this.session.getNode("/[xyz]")).thenReturn((Object)this.node);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertEquals((Object)this.node, (Object)converted.getNode());
    }

    @Test
    public void testDoBackward() {
        Resource converted = (Resource)this.converter.reverse().convert((Object)new FedoraResourceImpl(this.node));
        Assert.assertEquals((Object)this.resource, (Object)converted);
    }

    @Test
    public void testDoBackwardWithDatastreamContent() {
        Resource converted = (Resource)this.converter.reverse().convert((Object)new FedoraBinaryImpl(this.contentNode));
        Assert.assertEquals((Object)this.resource, (Object)converted);
    }

    @Test
    public void testDoBackwardWithDatastreamMetadata() {
        Resource converted = (Resource)this.converter.reverse().convert((Object)new NonRdfSourceDescriptionImpl(this.node));
        Assert.assertEquals((Object)this.metadataResource, (Object)converted);
    }

    @Test
    public void testDoBackwardWithHash() throws Exception {
        Mockito.when((Object)this.node.getPath()).thenReturn((Object)"arbitrary/path/#/with-a-hash");
        Resource converted = (Resource)this.converter.reverse().convert((Object)new FedoraResourceImpl(this.node));
        Assert.assertEquals((Object)ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path#with-a-hash"), (Object)converted);
    }

    @Test
    public void testDoForwardWithImplicitVersionedDatastream() throws Exception {
        Mockito.when((Object)this.session.getNodeByIdentifier("x")).thenReturn((Object)this.versionedNode);
        Mockito.when((Object)this.versionedNode.getProperty("jcr:frozenUuid")).thenReturn((Object)this.mockProperty);
        Mockito.when((Object)this.mockProperty.getString()).thenReturn((Object)"some-identifier");
        Mockito.when((Object)this.node.getIdentifier()).thenReturn((Object)"some-identifier");
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)this.versionedResource);
        Assert.assertEquals((Object)this.versionedNode, (Object)converted.getNode());
    }

    @Test
    public void testDoForwardWithExplicitVersionedDatastream() throws Exception {
        Mockito.when((Object)this.session.getNodeByIdentifier("x")).thenThrow(new Throwable[]{new ItemNotFoundException()});
        Mockito.when((Object)this.mockVersionManager.getVersionHistory("/arbitrary/path")).thenReturn((Object)this.mockVersionHistory);
        Mockito.when((Object)this.mockVersionHistory.hasVersionLabel("x")).thenReturn((Object)true);
        Mockito.when((Object)this.mockVersionHistory.getVersionByLabel("x")).thenReturn((Object)this.mockVersion);
        Mockito.when((Object)this.mockVersion.getFrozenNode()).thenReturn((Object)this.versionedNode);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)this.versionedResource);
        Assert.assertEquals((Object)this.versionedNode, (Object)converted.getNode());
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testDoForwardWithMissingVersionedDatastream() throws Exception {
        Mockito.when((Object)this.session.getNodeByIdentifier("x")).thenThrow(new Throwable[]{new ItemNotFoundException()});
        Mockito.when((Object)this.mockVersionManager.getVersionHistory("/arbitrary/path")).thenReturn((Object)this.mockVersionHistory);
        Mockito.when((Object)this.mockVersionHistory.hasVersionLabel("x")).thenReturn((Object)false);
        this.converter.convert((Object)this.versionedResource);
    }

    @Test
    @Ignore
    public void testDoBackwardWithVersionedNode() throws Exception {
        Mockito.when((Object)this.versionedNode.getProperty("jcr:frozenUuid")).thenReturn((Object)this.mockProperty);
        Mockito.when((Object)this.versionedNode.getIdentifier()).thenReturn((Object)"x");
        Mockito.when((Object)this.mockProperty.getString()).thenReturn((Object)"some-identifier");
        Mockito.when((Object)this.node.getIdentifier()).thenReturn((Object)"some-identifier");
        Mockito.when((Object)this.session.getNodeByIdentifier("some-identifier")).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isNodeType("mix:versionable")).thenReturn((Object)true);
        Resource converted = (Resource)this.converter.reverse().convert((Object)new FedoraResourceImpl(this.versionedNode));
        Assert.assertEquals((Object)this.versionedResource, (Object)converted);
    }

    @Test
    public void testDoBackwardWithTransaction() throws Exception {
        HttpResourceConverter converter = new HttpResourceConverter((Session)this.txSession, UriBuilder.fromUri((String)"http://localhost:8080/some/{path: .*}"));
        Mockito.when((Object)this.txSession.getTxId()).thenReturn((Object)"xyz");
        Mockito.when((Object)this.txSession.getNode("/arbitrary/path")).thenReturn((Object)this.node);
        Mockito.when((Object)this.txSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.node.getSession()).thenReturn((Object)this.txSession);
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/tx:xyz/arbitrary/path");
        Resource converted = (Resource)converter.reverse().convert((Object)new FedoraResourceImpl(this.node));
        Assert.assertEquals((Object)resource, (Object)converted);
    }

    @Test
    public void testToStringWithRoot() {
        Assert.assertEquals((Object)"/", (Object)this.converter.asString(ResourceFactory.createResource((String)"http://localhost:8080/some/")));
    }
}

