/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.text.ParseException;
import org.fcrepo.http.commons.domain.SinglePrefer;
import org.junit.Assert;
import org.junit.Test;

public class SinglePreferTest {
    protected SinglePrefer createTestPreferTypeFromHeader(String header) throws ParseException {
        return new SinglePrefer(header);
    }

    @Test
    public void testHasReturn() throws ParseException {
        SinglePrefer prefer = this.createTestPreferTypeFromHeader("return=representation");
        Assert.assertTrue((boolean)prefer.hasReturn());
    }

    @Test
    public void testGetReturn() throws ParseException {
        SinglePrefer prefer = this.createTestPreferTypeFromHeader("return=representation");
        Assert.assertEquals((Object)"representation", (Object)prefer.getReturn().getValue());
    }

    @Test
    public void testGetReturnParameters() throws ParseException {
        SinglePrefer prefer = this.createTestPreferTypeFromHeader("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMinimalContainer\"");
        Assert.assertTrue((boolean)prefer.hasReturn());
        Assert.assertEquals((Object)"representation", (Object)prefer.getReturn().getValue());
        String returnParams = (String)prefer.getReturn().getParams().get("include");
        Assert.assertTrue((boolean)returnParams.contains("http://www.w3.org/ns/ldp#PreferMinimalContainer"));
    }

    @Test
    public void testHasHandling() throws ParseException {
        SinglePrefer prefer = this.createTestPreferTypeFromHeader("handling=strict");
        Assert.assertTrue((boolean)prefer.hasHandling());
    }

    @Test
    public void testGetHandling() throws ParseException {
        SinglePrefer prefer = this.createTestPreferTypeFromHeader("handling=lenient");
        Assert.assertEquals((Object)"lenient", (Object)prefer.getHandling().getValue());
    }

    @Test
    public void testGetHandlingParameters() throws ParseException {
        SinglePrefer prefer = this.createTestPreferTypeFromHeader("handling=lenient; some=\"parameter\"");
        Assert.assertTrue((boolean)prefer.hasHandling());
        Assert.assertEquals((Object)"lenient", (Object)prefer.getHandling().getValue());
        String returnParams = (String)prefer.getHandling().getParams().get("some");
        Assert.assertTrue((boolean)returnParams.contains("parameter"));
    }
}

