/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.fcrepo.http.commons.exceptionhandlers.TombstoneExceptionMapper;
import org.fcrepo.kernel.exception.TombstoneException;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.Tombstone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class TombstoneExceptionMapperTest {
    private ExceptionMapper<TombstoneException> testObj;
    @Mock
    public Tombstone mockTombstone;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new TombstoneExceptionMapper();
    }

    @Test
    public void testUrilessException() {
        Response response = this.testObj.toResponse((Throwable)new TombstoneException((FedoraResource)this.mockTombstone));
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testExceptionWithUri() {
        Response response = this.testObj.toResponse((Throwable)new TombstoneException((FedoraResource)this.mockTombstone, "some:uri"));
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)response.getStatus());
        Link link = Link.valueOf((String)response.getHeaderString("Link"));
        Assert.assertEquals((Object)"some:uri", (Object)link.getUri().toString());
        Assert.assertEquals((Object)"hasTombstone", (Object)link.getRel());
    }
}

