/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.responses.RdfSerializationUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RdfSerializationUtilsTest {
    private final UriInfo info = (UriInfo)Mockito.mock(UriInfo.class);
    private final Model testData = ModelFactory.createDefaultModel();
    private PathSegment segment;

    @Before
    public void setup() {
        this.testData.add(ResourceFactory.createResource((String)"test:subject"), ResourceFactory.createProperty((String)"test:predicate"), (RDFNode)ResourceFactory.createTypedLiteral((Object)"test:object"));
        this.testData.add(ResourceFactory.createResource((String)"test:subject"), ResourceFactory.createProperty((String)"test:anotherPredicate"), (RDFNode)ResourceFactory.createTypedLiteral((Object)"test:object1"));
        this.testData.add(ResourceFactory.createResource((String)"test:subject"), ResourceFactory.createProperty((String)"test:anotherPredicate"), (RDFNode)ResourceFactory.createTypedLiteral((Object)"test:object2"));
        ArrayList<PathSegment> segments = new ArrayList<PathSegment>();
        this.segment = (PathSegment)Mockito.mock(PathSegment.class);
        segments.add(this.segment);
        Mockito.when((Object)this.info.getPathSegments()).thenReturn(segments);
    }

    @Test
    public void testGetFirstValueForPredicate() {
        String foundValue = RdfSerializationUtils.getFirstValueForPredicate((Model)this.testData, (Node)NodeFactory.createURI((String)"test:subject"), (Node)NodeFactory.createURI((String)"test:predicate"));
        Assert.assertEquals((String)"Didn't find correct value for predicate!", (Object)"test:object", (Object)foundValue);
    }

    @Test
    public void testGetAllValuesForPredicate() {
        Iterator foundValues = RdfSerializationUtils.getAllValuesForPredicate((Model)this.testData, (Node)NodeFactory.createURI((String)"test:subject"), (Node)NodeFactory.createURI((String)"test:anotherPredicate"));
        Assert.assertEquals((String)"Didn't find correct values for predicate!", (Object)ImmutableList.copyOf((Iterator)foundValues), (Object)ImmutableList.of((Object)"test:object1", (Object)"test:object2"));
    }
}

