/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import com.google.common.base.Throwables;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.exceptionhandlers.RepositoryExceptionMapper;
import org.fcrepo.http.commons.exceptionhandlers.TransactionMissingExceptionMapper;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WildcardExceptionMapper
implements ExceptionMapper<Exception> {
    Boolean showStackTrace = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(WildcardExceptionMapper.class);

    public Response toResponse(Exception e) {
        if (e.getCause() instanceof TransactionMissingException) {
            return new TransactionMissingExceptionMapper().toResponse((TransactionMissingException)e.getCause());
        }
        if (e.getCause() instanceof RepositoryException) {
            return new RepositoryExceptionMapper().toResponse((RepositoryException)e.getCause());
        }
        LOGGER.info("Exception intercepted by WildcardExceptionMapper: \n", (Throwable)e);
        return Response.serverError().entity((Object)(this.showStackTrace != false ? Throwables.getStackTraceAsString((Throwable)e) : null)).build();
    }

    public void setShowStackTrace(Boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }
}

