/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.fcrepo.http.commons.responses.RdfStreamProvider;
import org.fcrepo.kernel.api.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RdfStreamProviderTest {
    private RdfStreamProvider testProvider = new RdfStreamProvider();
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testProvider.registerMimeTypes();
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefixes()).thenReturn((Object)new String[0]);
    }

    @Test
    public void testGetSize() {
        Assert.assertEquals((long)-1L, (long)this.testProvider.getSize(null, null, null, null, null));
    }

    @Test
    public void testIsWriteable() {
        Assert.assertTrue((String)"Should be able to serialize this!", (boolean)this.testProvider.isWriteable(RdfStream.class, null, null, MediaType.valueOf((String)"application/rdf+xml")));
        Assert.assertFalse((String)"Should not be able to serialize this!", (boolean)this.testProvider.isWriteable(RdfStreamProviderTest.class, null, null, MediaType.valueOf((String)"application/rdf+xml")));
        Assert.assertFalse((String)"Should not be able to serialize this!", (boolean)this.testProvider.isWriteable(RdfStream.class, null, null, MediaType.valueOf((String)"text/html")));
    }

    @Test
    public void testWriteTo() throws WebApplicationException, IllegalArgumentException, IOException {
        byte[] result;
        Triple t = Triple.create((Node)NodeFactory.createURI((String)"info:test"), (Node)NodeFactory.createURI((String)"property:test"), (Node)NodeFactory.createURI((String)"info:test"));
        RdfStream rdfStream = new RdfStream(t).session(this.mockSession);
        try (ByteArrayOutputStream entityStream = new ByteArrayOutputStream();){
            this.testProvider.writeTo(rdfStream, RdfStream.class, null, null, MediaType.valueOf((String)"application/rdf+xml"), null, (OutputStream)entityStream);
            result = entityStream.toByteArray();
        }
        Model postSerialization = ModelFactory.createDefaultModel().read((InputStream)new ByteArrayInputStream(result), null);
        Assert.assertTrue((String)"Didn't find our triple!", (boolean)postSerialization.contains(postSerialization.asStatement(t)));
    }
}

