/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.fcrepo.http.commons.domain.RDFMediaType;
import org.fcrepo.http.commons.responses.RdfStreamStreamingOutput;
import org.fcrepo.kernel.api.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.Literals;
import org.openrdf.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfStreamStreamingOutputTest {
    private RdfStreamStreamingOutput testRdfStreamStreamingOutput;
    private static final Triple triple = Triple.create((Node)NodeFactory.createURI((String)"info:testSubject"), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)NodeFactory.createURI((String)"info:testObject"));
    @Mock
    private Node mockNode;
    private final RdfStream testRdfStream = new RdfStream(triple);
    @Mock
    private RdfStream mockRdfStream;
    private final MediaType testMediaType = MediaType.valueOf((String)"application/rdf+xml");
    private static final ValueFactory vf = ValueFactoryImpl.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamStreamingOutputTest.class);

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testRdfStreamStreamingOutput = new RdfStreamStreamingOutput(this.testRdfStream, this.testMediaType);
    }

    @Test
    public void testGetValueForObjectWithResource() {
        Node resource = NodeFactory.createURI((String)"info:test");
        Value result = RdfStreamStreamingOutput.getValueForObject((Node)resource);
        Assert.assertEquals((String)"Created bad Value!", (Object)vf.createURI("info:test"), (Object)result);
    }

    @Test
    public void testGetValueForObjectWithLiteral() {
        Node resource = NodeFactory.createLiteral((String)"test");
        Value result = RdfStreamStreamingOutput.getValueForObject((Node)resource);
        Assert.assertEquals((String)"Created bad Value!", (Object)Literals.createLiteral((ValueFactory)vf, (Object)"test"), (Object)result);
    }

    @Test
    public void testWrite() throws IOException {
        this.assertOutputContainsTriple(triple);
    }

    public void assertOutputContainsTriple(Triple expected) throws IOException {
        RdfStream input = new RdfStream(expected);
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput(input, this.testMediaType).write((OutputStream)output);
            try (ByteArrayInputStream resultStream = new ByteArrayInputStream(output.toByteArray());){
                Model result = ModelFactory.createDefaultModel().read((InputStream)resultStream, null);
                Assert.assertTrue((String)"Didn't find our test triple!", (boolean)result.contains(result.asStatement(expected)));
            }
        }
    }

    @Test
    public void testWriteWithNamespace() throws IOException {
        RdfStream input = new RdfStream().namespace("a", "info:a");
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput(input, RDFMediaType.TURTLE_TYPE).write((OutputStream)output);
            String s = output.toString("UTF-8");
            Assert.assertTrue((boolean)s.contains("@prefix a: <info:a>"));
        }
    }

    @Test
    public void testWriteWithXmlnsNamespace() throws IOException {
        RdfStream input = new RdfStream().namespace("xmlns", "info:a");
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput(input, RDFMediaType.TURTLE_TYPE).write((OutputStream)output);
            String s = output.toString("UTF-8");
            Assert.assertFalse((boolean)s.contains("@prefix xmlns"));
        }
    }

    @Test
    public void testWriteWithTypedObject() throws IOException {
        this.assertOutputContainsTriple(Triple.create((Node)NodeFactory.createURI((String)"info:testSubject"), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)ResourceFactory.createTypedLiteral((Object)0).asNode()));
    }

    @Test
    public void testWriteWithBlankSubject() throws IOException {
        RdfStream input = new RdfStream(Triple.create((Node)ResourceFactory.createResource().asNode(), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)ResourceFactory.createTypedLiteral((Object)0).asNode()));
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput(input, this.testMediaType).write((OutputStream)output);
            try (ByteArrayInputStream resultStream = new ByteArrayInputStream(output.toByteArray());){
                Model result = ModelFactory.createDefaultModel().read((InputStream)resultStream, null);
                Assert.assertTrue((boolean)result.contains(null, ResourceFactory.createProperty((String)"info:testPredicate"), (RDFNode)ResourceFactory.createTypedLiteral((Object)0)));
            }
        }
    }

    @Test
    public void testWriteWithBlankObject() throws IOException {
        RdfStream input = new RdfStream(Triple.create((Node)ResourceFactory.createResource().asNode(), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)ResourceFactory.createResource().asNode()));
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput(input, this.testMediaType).write((OutputStream)output);
            try (ByteArrayInputStream resultStream = new ByteArrayInputStream(output.toByteArray());){
                Model result = ModelFactory.createDefaultModel().read((InputStream)resultStream, null);
                Assert.assertTrue((boolean)result.contains(null, ResourceFactory.createProperty((String)"info:testPredicate"), (RDFNode)null));
            }
        }
    }

    @Test
    public void testWriteWithDatetimeObject() throws IOException {
        this.assertOutputContainsTriple(Triple.create((Node)NodeFactory.createURI((String)"info:testSubject"), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)NodeFactory.createLiteral((String)"2014-01-01T01:02:03Z", (RDFDatatype)XSDDatatype.XSDdateTime)));
    }

    @Test
    public void testWriteWithLanguageLiteral() throws IOException {
        this.assertOutputContainsTriple(Triple.create((Node)NodeFactory.createURI((String)"info:testSubject"), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)NodeFactory.createLiteral((String)"french string", (String)"fr", (RDFDatatype)XSDDatatype.XSDstring)));
    }

    @Test(expected=WebApplicationException.class)
    public void testWriteWithException() throws IOException {
        FutureCallback<Void> callback = new FutureCallback<Void>(){

            public void onSuccess(Void v) {
                throw new AssertionError((Object)"Should never happen!");
            }

            public void onFailure(Throwable e) {
                LOGGER.debug("Got exception:", e);
                Assert.assertTrue((String)"Got wrong kind of exception!", (boolean)(e instanceof RDFHandlerException));
            }
        };
        Futures.addCallback((ListenableFuture)this.testRdfStreamStreamingOutput, (FutureCallback)callback);
        try (OutputStream mockOutputStream = (OutputStream)Mockito.mock(OutputStream.class, (Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws IOException {
                throw new IOException("Expected.");
            }
        });){
            this.testRdfStreamStreamingOutput.write(mockOutputStream);
        }
    }
}

