/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.text.ParseException;
import java.util.Set;
import java.util.TreeSet;
import org.fcrepo.http.commons.domain.PreferTag;
import org.glassfish.jersey.message.internal.HttpHeaderReader;

public class SinglePrefer {
    private final Set<PreferTag> preferTags = new TreeSet<PreferTag>();

    public SinglePrefer(String header) throws ParseException {
        this.preferTags.addAll(HttpHeaderReader.readList(PreferTag::new, (String)header));
    }

    public Boolean hasReturn() {
        return this.preferTags().stream().map(PreferTag::getTag).anyMatch("return"::equals);
    }

    public Boolean hasHandling() {
        return this.preferTags().stream().map(PreferTag::getTag).anyMatch("handling"::equals);
    }

    public PreferTag getReturn() {
        return this.preferTags().stream().filter(x -> x.getTag().equals("return")).findFirst().orElse(PreferTag.emptyTag());
    }

    public PreferTag getHandling() {
        return this.preferTags().stream().filter(x -> x.getTag().equals("handling")).findFirst().orElse(PreferTag.emptyTag());
    }

    protected Set<PreferTag> preferTags() {
        return this.preferTags;
    }
}

