/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.JSONLDMode;
import org.openrdf.rio.helpers.JSONLDSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterConfigHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriterConfigHelper.class);
    public static final String PROFILE_KEY = "profile";
    public static final String PROFILE_COMPACT = "http://www.w3.org/ns/json-ld#compacted";
    public static final String PROFILE_FLATTEN = "http://www.w3.org/ns/json-ld#flattened";
    public static final String PROFILE_EXPAND = "http://www.w3.org/ns/json-ld#expanded";

    private WriterConfigHelper() {
    }

    public static WriterConfig apply(MediaType mediaType) {
        WriterConfig config = new WriterConfig();
        if (!mediaType.isCompatible(MediaType.valueOf((String)RDFFormat.JSONLD.getDefaultMIMEType()))) {
            return config;
        }
        Map params = mediaType.getParameters();
        if (null != params && params.containsKey(PROFILE_KEY)) {
            String profile;
            switch (profile = (String)params.get(PROFILE_KEY)) {
                case "http://www.w3.org/ns/json-ld#compacted": {
                    config.set(JSONLDSettings.JSONLD_MODE, (Object)JSONLDMode.COMPACT);
                    break;
                }
                case "http://www.w3.org/ns/json-ld#flattened": {
                    config.set(JSONLDSettings.JSONLD_MODE, (Object)JSONLDMode.FLATTEN);
                    break;
                }
                case "http://www.w3.org/ns/json-ld#expanded": {
                    config.set(JSONLDSettings.JSONLD_MODE, (Object)JSONLDMode.EXPAND);
                    break;
                }
                default: {
                    LOGGER.debug("No profile found in {}", (Object)mediaType);
                }
            }
        }
        return config;
    }
}

