/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import java.io.IOException;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.fcrepo.http.commons.exceptionhandlers.MalformedRdfExceptionMapper;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MalformedRdfExceptionMapperTest {
    private MalformedRdfExceptionMapper testObj;

    @Before
    public void setUp() {
        this.testObj = new MalformedRdfExceptionMapper();
    }

    @Test
    public void testToResponse() throws IOException {
        Response response = this.testObj.toResponse(new MalformedRdfException("xyz"));
        Link link = response.getLink(RdfLexicon.CONSTRAINED_BY.getURI());
        Assert.assertEquals((Object)RdfLexicon.CONSTRAINED_BY.getURI(), (Object)link.getRel());
        Assert.assertEquals((Object)"data", (Object)link.getUri().getScheme());
        String[] split = link.getUri().toString().split(",", 2);
        Assert.assertEquals((String)"Constraint data appears malformed", (long)2L, (long)split.length);
        Assert.assertEquals((Object)"xyz", (Object)IOUtils.toString((byte[])Base64.decodeBase64((byte[])split[1].getBytes()), (String)"UTF-8"));
    }

    @Test
    public void testToResponseError() throws IOException {
        String errorPrefix = "org.modeshape.jcr.value.ValueFormatException: ";
        String errorSuffix = "Error converting ...";
        Response response = this.testObj.toResponse(new MalformedRdfException("org.modeshape.jcr.value.ValueFormatException: Error converting ..."));
        Assert.assertEquals((Object)"Error converting ...", (Object)response.getEntity().toString());
    }

    @Test
    public void testToResponseError2() throws IOException {
        String errorPrefix = "org.modeshape.jcr.value.ValueFormat: ";
        String errorSuffix = "Error converting ...";
        Response response = this.testObj.toResponse(new MalformedRdfException("org.modeshape.jcr.value.ValueFormat: Error converting ..."));
        Assert.assertEquals((Object)"org.modeshape.jcr.value.ValueFormat: Error converting ...", (Object)response.getEntity().toString());
    }
}

