/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableMap;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.responses.ViewHelpers;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.api.RdfLexicon;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewHelpersTest {
    private ViewHelpers testObj;

    @Before
    public void setUp() {
        this.testObj = ViewHelpers.getInstance();
    }

    @Test
    public void testGetVersions() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Node version = NodeFactory.createURI((String)"http://localhost/fcrepo/abc/fcr:version/adcd");
        String date = new Date().toString();
        mem.add(new Triple(NodeFactory.createURI((String)"http://localhost/fcrepo/abc"), RdfLexicon.HAS_VERSION.asNode(), version));
        mem.add(new Triple(version, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)date)));
        Assert.assertEquals((String)"Version should be available.", (Object)version, this.testObj.getVersions(mem, NodeFactory.createURI((String)"http://localhost/fcrepo/abc")).next());
    }

    @Test
    public void testGetOrderedVersions() {
        Node resource = NodeFactory.createURI((String)"http://localhost/fcrepo/abc");
        Node v1 = NodeFactory.createURI((String)"http://localhost/fcrepo/abc/fcr:version/1");
        Node v2 = NodeFactory.createURI((String)"http://localhost/fcrepo/abc/fcr:version/2");
        Node v3 = NodeFactory.createURI((String)"http://localhost/fcrepo/abc/fcr:version/3");
        Date now = new Date();
        Date later = new Date();
        later.setTime(later.getTime() + 10000L);
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(resource, RdfLexicon.HAS_VERSION.asNode(), v1));
        mem.add(new Triple(v1, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)now.toString())));
        mem.add(new Triple(resource, RdfLexicon.HAS_VERSION.asNode(), v2));
        mem.add(new Triple(v2, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)now.toString())));
        mem.add(new Triple(resource, RdfLexicon.HAS_VERSION.asNode(), v3));
        mem.add(new Triple(v3, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)later.toString())));
        Iterator versions = this.testObj.getOrderedVersions(mem, resource, (Resource)RdfLexicon.HAS_VERSION);
        versions.next();
        versions.next();
        Node r3 = (Node)versions.next();
        Assert.assertEquals((String)"Latest version should be last.", (Object)v3, (Object)r3);
    }

    @Test
    public void shouldConvertAUriToNodeBreadcrumbs() {
        UriInfo mockUriInfo = TestHelpers.getUriInfoImpl();
        Map nodeBreadcrumbs = this.testObj.getNodeBreadcrumbs(mockUriInfo, ResourceFactory.createResource((String)"http://localhost/fcrepo/a/b/c").asNode());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"http://localhost/fcrepo/a", (Object)"a", (Object)"http://localhost/fcrepo/a/b", (Object)"b", (Object)"http://localhost/fcrepo/a/b/c", (Object)"c"), (Object)nodeBreadcrumbs);
    }

    @Test
    public void shouldRefuseToConvertAForeignUriToNodeBreadcrumbs() {
        UriInfo mockUriInfo = TestHelpers.getUriInfoImpl();
        Map nodeBreadcrumbs = this.testObj.getNodeBreadcrumbs(mockUriInfo, ResourceFactory.createResource((String)"http://somewhere/else/a/b/c").asNode());
        Assert.assertTrue((boolean)nodeBreadcrumbs.isEmpty());
    }

    @Test
    public void testIsWritable() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.WRITABLE.asNode(), NodeFactory.createLiteral((String)Boolean.TRUE.toString())));
        Assert.assertTrue((String)"Node is should be writable.", (boolean)this.testObj.isWritable(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testIsWritableFalse() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.WRITABLE.asNode(), NodeFactory.createLiteral((String)Boolean.FALSE.toString())));
        Assert.assertFalse((String)"Node should not be writable.", (boolean)this.testObj.isWritable(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testIsWritableFalseJunk() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.DESCRIBES.asNode(), NodeFactory.createLiteral((String)"junk")));
        Assert.assertFalse((String)"Node should not be writable.", (boolean)this.testObj.isWritable(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testIsVersionedNode() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RDF.type.asNode(), NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#Version")));
        Assert.assertTrue((String)"Node is a versioned node.", (boolean)this.testObj.isVersionedNode(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testIsNotVersionedNode() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.HAS_PRIMARY_TYPE.asNode(), NodeFactory.createLiteral((String)"nt:file")));
        Assert.assertFalse((String)"Node is not a versioned node.", (boolean)this.testObj.isVersionedNode(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testRdfResource() {
        String ns = "http://any/namespace#";
        String type = "anyType";
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b"), ResourceFactory.createResource((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type").asNode(), ResourceFactory.createResource((String)"http://any/namespace#anyType").asNode()));
        Assert.assertTrue((String)"Node is a anyType node.", (boolean)this.testObj.isRdfResource(mem, NodeFactory.createURI((String)"a/b"), "http://any/namespace#", "anyType"));
        Assert.assertFalse((String)"Node is not a anyType node.", (boolean)this.testObj.isRdfResource(mem, NodeFactory.createURI((String)"a/b"), "http://any/namespace#", "otherType"));
    }

    @Test
    public void shouldFindVersionRoot() {
        UriInfo mockUriInfo = TestHelpers.getUriInfoImpl();
        String nodeUri = this.testObj.getVersionSubjectUrl(mockUriInfo, ResourceFactory.createResource((String)"http://localhost/fcrepo/a/b/fcr:versions/c").asNode());
        Assert.assertEquals((Object)"http://localhost/fcrepo/a/b", (Object)nodeUri);
    }

    @Test
    public void testGetLabeledVersion() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        String label = "testLabel";
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.HAS_VERSION_LABEL.asNode(), NodeFactory.createLiteral((String)"testLabel")));
        Assert.assertEquals((String)"Version label should be available.", (Object)"testLabel", (Object)this.testObj.getVersionLabel(mem, NodeFactory.createURI((String)"a/b/c")).orElse(""));
    }

    @Test
    public void testGetUnlabeledVersion() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Assert.assertEquals((String)"Default version label should be used.", (Object)"d", (Object)this.testObj.getVersionLabel(mem, NodeFactory.createURI((String)"a/b/c")).orElse("d"));
    }

    @Test
    public void testGetVersionDate() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        String date = new Date().toString();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)date)));
        Assert.assertEquals((String)"Date should be available.", (Object)date, this.testObj.getVersionDate(mem, NodeFactory.createURI((String)"a/b/c")).get());
    }

    @Test
    public void testGetMissingVersionDate() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Assert.assertFalse((String)"Date should not be available.", (boolean)this.testObj.getVersionDate(mem, NodeFactory.createURI((String)"a/b/c")).isPresent());
    }

    @Test
    public void shouldExtractTitleFromNode() {
        this.shouldExtractTitleFromNode(RdfLexicon.DC_TITLE);
        this.shouldExtractTitleFromNode(RdfLexicon.DCTERMS_TITLE);
        this.shouldExtractTitleFromNode(RdfLexicon.RDFS_LABEL);
        this.shouldExtractTitleFromNode(RdfLexicon.SKOS_PREFLABEL);
    }

    private void shouldExtractTitleFromNode(Property property) {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), property.asNode(), NodeFactory.createLiteral((String)"abc")));
        Assert.assertEquals((Object)"abc", (Object)this.testObj.getObjectTitle(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldUseTheObjectUriIfATitleIsNotAvailable() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.DC_TITLE.asNode(), NodeFactory.createURI((String)"d/e/f")));
        Assert.assertEquals((Object)"a/b/c", (Object)this.testObj.getObjectTitle(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldUsetheBNodeIdIfItIsABNode() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Node anon = NodeFactory.createAnon();
        Assert.assertEquals((Object)anon.getBlankNodeLabel(), (Object)this.testObj.getObjectTitle(mem, anon));
    }

    @Test
    public void shouldJustUseTheStringIfItIsALiteral() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Node lit = NodeFactory.createLiteral((String)"xyz");
        Assert.assertEquals((Object)"\"xyz\"", (Object)this.testObj.getObjectTitle(mem, lit));
    }

    @Test
    public void shouldGetSerializationFormat() {
        String serialKey = "jcr/xml";
        Node formatRDF = NodeFactory.createLiteral((String)"http://fedora.info/definitions/v4/repository#jcr/xml");
        Node subject = NodeFactory.createLiteral((String)"xyz");
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Property dcFormat = ResourceFactory.createProperty((String)"http://purl.org/dc/elements/1.1/format");
        mem.add(new Triple(formatRDF, RdfLexicon.RDFS_LABEL.asNode(), NodeFactory.createLiteral((String)"jcr/xml")));
        mem.add(new Triple(subject, dcFormat.asNode(), formatRDF));
        Assert.assertEquals((Object)"jcr/xml", this.testObj.getSerializationTitle(mem, subject).get());
    }

    @Test
    public void shouldConvertRdfObjectsToStrings() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a/b/c"), NodeFactory.createLiteral((String)"abc")));
        mem.add(new Triple(NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a-numeric-type"), ResourceFactory.createTypedLiteral((Object)0).asNode()));
        mem.add(new Triple(NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"an-empty-string"), NodeFactory.createLiteral((String)"")));
        mem.add(new Triple(NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a-uri"), NodeFactory.createURI((String)"some-uri")));
        Assert.assertEquals((Object)"abc", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a/b/c"), true));
        Assert.assertEquals((Object)"0", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-numeric-type"), true));
        Assert.assertEquals((Object)"<empty>", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"an-empty-string"), true));
        Assert.assertEquals((Object)"&lt;<a href=\"some-uri\">some-uri</a>&gt;", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-uri"), true));
        Assert.assertEquals((Object)"some-uri", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-uri"), false));
        Assert.assertEquals((Object)"", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-nonexistent-uri"), true));
    }

    @Test
    public void shouldExtractNamespaceAndPrefix() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        Assert.assertEquals((Object)"prefix:", (Object)this.testObj.getNamespacePrefix((PrefixMapping)model, "namespace", false));
        Assert.assertEquals((Object)"some-other-namespace", (Object)this.testObj.getNamespacePrefix((PrefixMapping)model, "some-other-namespace", false));
    }

    @Test
    public void shouldSortTriplesForDisplay() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        Property propertyA = model.createProperty("namespace", "a");
        Property propertyB = model.createProperty("namespace", "b");
        Property propertyC = model.createProperty("c");
        Literal literalA = model.createLiteral("a");
        Literal literalB = model.createLiteral("b");
        Resource resourceB = model.createResource("b");
        model.add(resourceB, propertyA, (RDFNode)literalA);
        Resource a = model.createResource("a");
        model.add(a, propertyC, (RDFNode)literalA);
        model.add(a, propertyB, (RDFNode)literalA);
        model.add(a, propertyA, (RDFNode)literalA);
        model.add(a, propertyA, (RDFNode)literalB);
        ExtendedIterator iterator = model.getGraph().find(null, null, null);
        List sortedTriples = this.testObj.getSortedTriples(model, (Iterator)iterator);
        ((Triple)sortedTriples.get(0)).matches(a.asNode(), propertyA.asNode(), literalA.asNode());
        ((Triple)sortedTriples.get(1)).matches(a.asNode(), propertyA.asNode(), literalB.asNode());
        ((Triple)sortedTriples.get(2)).matches(a.asNode(), propertyB.asNode(), literalA.asNode());
        ((Triple)sortedTriples.get(3)).matches(a.asNode(), propertyC.asNode(), literalA.asNode());
        ((Triple)sortedTriples.get(4)).matches(resourceB.asNode(), propertyC.asNode(), literalA.asNode());
    }

    @Test
    public void shouldConvertPrefixMappingToSparqlUpdatePrefixPreamble() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        String prefixPreamble = this.testObj.getPrefixPreamble((PrefixMapping)model);
        Assert.assertEquals((Object)"PREFIX prefix: <namespace>\n\n", (Object)prefixPreamble);
    }

    @Test
    public void shouldConvertStringLiteralsToNodes() {
        String uri = "fedora:resource";
        Literal URIRES = ResourceFactory.createPlainLiteral((String)"fedora:resource");
        Assert.assertEquals((Object)URIRES.asNode(), (Object)this.testObj.asLiteralStringNode("fedora:resource"));
    }

    @Test
    public void testGetNumChildren() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.HAS_CHILD_COUNT.asNode(), ResourceFactory.createTypedLiteral((Object)4).asNode()));
        Assert.assertEquals((long)4L, (long)this.testObj.getNumChildren(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testGetNumChildrenEmpty() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.HAS_CHILD_COUNT.asNode(), NodeFactory.createLiteral((String)"")));
        Assert.assertEquals((long)0L, (long)this.testObj.getNumChildren(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testGetNumChildrenNone() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Assert.assertEquals((long)0L, (long)this.testObj.getNumChildren(mem, NodeFactory.createURI((String)"a/b/c")));
    }
}

