/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import java.util.Arrays;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import org.fcrepo.http.commons.responses.WriterConfigHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.JSONLDMode;
import org.openrdf.rio.helpers.JSONLDSettings;

@RunWith(value=Parameterized.class)
public class WriterConfigHelperTest {
    @Parameterized.Parameter(value=0)
    public MediaType mediaType;
    @Parameterized.Parameter(value=1)
    public JSONLDMode profile;

    @Parameterized.Parameters(name="{index}: mediaType:{0} => {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({new MediaType(null, null), null}, {new MediaType(null, "ld+json"), null}, {new MediaType("application", null), null}, {new MediaType("", ""), null}, {new MediaType("*", "*"), null}, {new MediaType("*", "pdf"), null}, {new MediaType("*", "ld+json"), null}, {new MediaType("application", "*"), null}, {new MediaType("application", "pdf"), null}, {new MediaType("application", "ld+json"), null}, {new MediaType("application", "ld+json", Collections.singletonMap("profile", "http://www.w3.org/ns/json-ld#compacted")), JSONLDMode.COMPACT}, {new MediaType("application", "ld+json", Collections.singletonMap("profile", "http://www.w3.org/ns/json-ld#flattened")), JSONLDMode.FLATTEN}, {new MediaType("application", "ld+json", Collections.singletonMap("profile", "http://www.w3.org/ns/json-ld#expanded")), JSONLDMode.EXPAND});
    }

    @Test
    public void testApply() throws Exception {
        WriterConfig config = WriterConfigHelper.apply((MediaType)this.mediaType);
        if (null == this.profile) {
            Assert.assertFalse((String)"JSONLD_MODE should not be set!", (boolean)config.isSet(JSONLDSettings.JSONLD_MODE));
        } else {
            Assert.assertEquals((String)("JSONLD_MODE should have been: " + this.profile), (Object)config.get(JSONLDSettings.JSONLD_MODE), (Object)this.profile);
        }
    }
}

