/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.google.common.base.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.kernel.api.exception.IdentifierConversionException;
import org.fcrepo.kernel.api.exception.InvalidResourceIdentifierException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.exception.TombstoneException;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.modeshape.TombstoneImpl;
import org.fcrepo.kernel.modeshape.identifiers.HashConverter;
import org.fcrepo.kernel.modeshape.identifiers.NamespaceConverter;
import org.fcrepo.kernel.modeshape.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.modeshape.services.TransactionServiceImpl;
import org.fcrepo.kernel.modeshape.utils.FedoraTypesUtils;
import org.fcrepo.kernel.modeshape.utils.NamespaceTools;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;

public class HttpResourceConverter
extends IdentifierConverter<Resource, FedoraResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceConverter.class);
    protected List<Converter<String, String>> translationChain;
    private final Session session;
    private final UriBuilder uriBuilder;
    protected Converter<String, String> forward = HttpResourceConverter.identity();
    protected Converter<String, String> reverse = HttpResourceConverter.identity();
    private final UriTemplate uriTemplate;
    private static final List<Converter<String, String>> minimalTranslationChain = ImmutableList.of((Object)new NamespaceConverter(), (Object)new HashConverter());

    public HttpResourceConverter(Session session, UriBuilder uriBuilder) {
        this.session = session;
        this.uriBuilder = uriBuilder;
        this.uriTemplate = new UriTemplate(uriBuilder.toTemplate());
        this.resetTranslationChain();
    }

    private UriBuilder uriBuilder() {
        return UriBuilder.fromUri((String)this.uriBuilder.toTemplate());
    }

    protected FedoraResource doForward(Resource resource) {
        HashMap<String, String> values = new HashMap<String, String>();
        String path = this.asString(resource, values);
        try {
            if (path != null) {
                Node node = this.getNode(path);
                boolean metadata = values.containsKey("path") && ((String)values.get("path")).endsWith("/fcr:metadata");
                FedoraResource fedoraResource = (FedoraResource)NodeResourceConverter.nodeConverter.convert((Object)node);
                if (!metadata && fedoraResource instanceof NonRdfSourceDescription) {
                    return ((NonRdfSourceDescription)fedoraResource).getDescribedResource();
                }
                return fedoraResource;
            }
            throw new IdentifierConversionException("Asked to translate a resource " + resource + " that doesn't match the URI template");
        }
        catch (RepositoryException e) {
            NamespaceTools.validatePath((Session)this.session, (String)path);
            if (e instanceof PathNotFoundException) {
                try {
                    Node preexistingNode = FedoraTypesUtils.getClosestExistingAncestor((Session)this.session, (String)path);
                    if (TombstoneImpl.hasMixin((Node)preexistingNode)) {
                        throw new TombstoneException((FedoraResource)new TombstoneImpl(preexistingNode));
                    }
                }
                catch (RepositoryException inner) {
                    LOGGER.debug("Error checking for parent tombstones", (Throwable)inner);
                }
            }
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    protected Resource doBackward(FedoraResource resource) {
        return this.toDomain(this.doBackwardPathOnly(resource));
    }

    public boolean inDomain(Resource resource) {
        HashMap values = new HashMap();
        return this.uriTemplate.match((CharSequence)resource.getURI(), values) && values.containsKey("path");
    }

    public Resource toDomain(String path) {
        String realPath = path == null ? "" : (path.startsWith("/") ? path.substring(1) : path);
        UriBuilder uri = this.uriBuilder();
        if (realPath.contains("#")) {
            String[] split = realPath.split("#", 2);
            uri.resolveTemplate("path", (Object)split[0], false);
            uri.fragment(split[1]);
        } else {
            uri.resolveTemplate("path", (Object)realPath, false);
        }
        return ResourceFactory.createResource((String)uri.build(new Object[0]).toString());
    }

    public String asString(Resource resource) {
        HashMap<String, String> values = new HashMap<String, String>();
        return this.asString(resource, values);
    }

    private String asString(Resource resource, Map<String, String> values) {
        if (this.uriTemplate.match((CharSequence)resource.getURI(), values) && values.containsKey("path")) {
            String path = "/" + values.get("path");
            boolean metadata = path.endsWith("/fcr:metadata");
            if (metadata) {
                path = StringUtils.replaceOnce((String)path, (String)"/fcr:metadata", (String)"");
            }
            if ((path = (String)this.forward.convert((Object)path)) == null) {
                return null;
            }
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.debug("Unable to URL-decode path " + e + " as UTF-8", (Throwable)e);
            }
            if (path.isEmpty()) {
                return "/";
            }
            if (path.contains("//")) {
                throw new InvalidResourceIdentifierException("Path contains empty element! " + path);
            }
            return path;
        }
        return null;
    }

    private Node getNode(String path) throws RepositoryException {
        if (path.contains("fcr:versions")) {
            String[] split = path.split("/fcr:versions/", 2);
            String versionedPath = split[0];
            String versionAndPathIntoVersioned = split[1];
            String[] split1 = versionAndPathIntoVersioned.split("/", 2);
            String version = split1[0];
            String pathIntoVersioned = split1.length > 1 ? split1[1] : "";
            Node node = this.getFrozenNodeByLabel(versionedPath, version);
            if (pathIntoVersioned.isEmpty()) {
                return node;
            }
            if (node != null) {
                return node.getNode(pathIntoVersioned);
            }
            throw new PathNotFoundException("Unable to find versioned resource at " + path);
        }
        return this.session.getNode(path);
    }

    private Node getFrozenNodeByLabel(String baseResourcePath, String label) {
        try {
            Node n = this.getNode(baseResourcePath, label);
            if (n != null) {
                return n;
            }
            VersionHistory hist = this.session.getWorkspace().getVersionManager().getVersionHistory(baseResourcePath);
            if (hist.hasVersionLabel(label)) {
                LOGGER.debug("Found version for {} by label {}.", (Object)baseResourcePath, (Object)label);
                return hist.getVersionByLabel(label).getFrozenNode();
            }
            LOGGER.warn("Unknown version {} with label or uuid {}!", (Object)baseResourcePath, (Object)label);
            throw new PathNotFoundException("Unknown version " + baseResourcePath + " with label or uuid " + label);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private Node getNode(String baseResourcePath, String label) throws RepositoryException {
        try {
            Node frozenNode = this.session.getNodeByIdentifier(label);
            Property p = frozenNode.getProperty("jcr:frozenUuid");
            if (p != null) {
                Node subjectNode = this.session.getNode(baseResourcePath);
                if (p.getString().equals(subjectNode.getIdentifier())) {
                    return frozenNode;
                }
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static String getPath(FedoraResource resource) {
        if (FedoraTypesUtils.isFrozenNode.test(resource)) {
            try {
                FedoraResource versionableFrozenResource = resource.getVersionedAncestor();
                FedoraResource unfrozenVersionableResource = versionableFrozenResource.getUnfrozenResource();
                String versionIdentifier = versionableFrozenResource.getNode().getIdentifier();
                String pathWithinVersionable = !resource.equals(versionableFrozenResource) ? HttpResourceConverter.getRelativePath(resource, versionableFrozenResource) : "";
                String path = unfrozenVersionableResource.getPath() + "/" + "fcr:versions" + "/" + versionIdentifier + pathWithinVersionable;
                return path.startsWith("/") ? path : "/" + path;
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
        return resource.getPath();
    }

    private static String getRelativePath(FedoraResource child, FedoraResource ancestor) {
        return child.getPath().substring(ancestor.getPath().length());
    }

    private String doBackwardPathOnly(FedoraResource resource) {
        String path = (String)this.reverse.convert((Object)HttpResourceConverter.getPath(resource));
        if (path != null) {
            if (resource instanceof NonRdfSourceDescription) {
                path = path + "/" + "fcr:metadata";
            }
            if (path.endsWith("jcr:content")) {
                path = StringUtils.replaceOnce((String)path, (String)"/jcr:content", (String)"");
            }
            return path;
        }
        throw new RepositoryRuntimeException("Unable to process reverse chain for resource " + resource);
    }

    protected void resetTranslationChain() {
        if (this.translationChain == null) {
            this.translationChain = this.getTranslationChain();
            ArrayList<Converter<String, String>> newChain = new ArrayList<Converter<String, String>>(Collections.singleton(new TransactionIdentifierConverter(this.session)));
            newChain.addAll(this.translationChain);
            this.setTranslationChain(newChain);
        }
    }

    private void setTranslationChain(List<Converter<String, String>> chained) {
        this.translationChain = chained;
        for (Converter<String, String> converter : this.translationChain) {
            this.forward = this.forward.andThen(converter);
        }
        for (Converter converter : Lists.reverse(this.translationChain)) {
            this.reverse = this.reverse.andThen(converter.reverse());
        }
    }

    protected List<Converter<String, String>> getTranslationChain() {
        ApplicationContext context = this.getApplicationContext();
        if (context != null) {
            List tchain = (List)this.getApplicationContext().getBean("translationChain", List.class);
            return tchain;
        }
        return minimalTranslationChain;
    }

    protected ApplicationContext getApplicationContext() {
        return ContextLoader.getCurrentWebApplicationContext();
    }

    static class TransactionIdentifierConverter
    extends Converter<String, String> {
        public static final String TX_PREFIX = "tx:";
        private final Session session;

        public TransactionIdentifierConverter(Session session) {
            this.session = session;
        }

        protected String doForward(String path) {
            if (path.contains(TX_PREFIX) && !path.contains(this.txSegment())) {
                throw new RepositoryRuntimeException("Path " + path + " is not in current transaction " + TransactionServiceImpl.getCurrentTransactionId((Session)this.session));
            }
            return StringUtils.replaceOnce((String)path, (String)this.txSegment(), (String)"");
        }

        protected String doBackward(String path) {
            return this.txSegment() + path;
        }

        private String txSegment() {
            String txId = TransactionServiceImpl.getCurrentTransactionId((Session)this.session);
            if (txId != null) {
                return "/tx:" + txId;
            }
            return "";
        }
    }
}

