/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.UriAwareResourceModelFactory;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HttpTripleUtil
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTripleUtil.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void addHttpComponentModelsForResourceToStream(RdfStream rdfStream, FedoraResource resource, UriInfo uriInfo, IdentifierConverter<Resource, FedoraResource> idTranslator) {
        LOGGER.debug("Adding additional HTTP context triples to stream");
        this.getUriAwareTripleFactories().forEach((bean, factory) -> {
            LOGGER.debug("Adding response information using: {}", bean);
            Model m = factory.createModelForResource(resource, uriInfo, idTranslator);
            rdfStream.concat((Iterator)RdfStream.fromModel((Model)m));
        });
    }

    private Map<String, UriAwareResourceModelFactory> getUriAwareTripleFactories() {
        return this.applicationContext.getBeansOfType(UriAwareResourceModelFactory.class);
    }
}

