/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractFuture;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.fcrepo.http.commons.responses.WriterConfigHelper;
import org.fcrepo.http.commons.utils.UncheckedBiConsumer;
import org.fcrepo.kernel.api.utils.iterators.RdfStream;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.Literals;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.WriterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfStreamStreamingOutput
extends AbstractFuture<Void>
implements StreamingOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamStreamingOutput.class);
    private static ValueFactory vfactory = ValueFactoryImpl.getInstance();
    private final RDFFormat format;
    private final MediaType mediaType;
    private final RdfStream rdfStream;
    protected static final Function<? super Triple, Statement> toStatement = t -> {
        Resource subject = RdfStreamStreamingOutput.getResourceForSubject(t.getSubject());
        URI predicate = vfactory.createURI(t.getPredicate().getURI());
        Value object = RdfStreamStreamingOutput.getValueForObject(t.getObject());
        return vfactory.createStatement(subject, predicate, object);
    };

    public RdfStreamStreamingOutput(RdfStream rdfStream, MediaType mediaType) {
        RDFFormat format;
        if (LOGGER.isDebugEnabled()) {
            for (RDFFormat writeableFormats : RDFWriterRegistry.getInstance().getKeys()) {
                LOGGER.debug("Discovered RDF writer writeableFormats: {} with mimeTypes: {}", (Object)writeableFormats.getName(), (Object)String.join((CharSequence)" ", writeableFormats.getMIMETypes()));
            }
        }
        if ((format = Rio.getWriterFormatForMIMEType((String)mediaType.toString())) == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        this.format = format;
        this.mediaType = mediaType;
        LOGGER.debug("Setting up to serialize to: {}", (Object)format);
        this.rdfStream = rdfStream;
    }

    public void write(OutputStream output) {
        LOGGER.debug("Serializing RDF stream in: {}", (Object)this.format);
        try {
            this.write(() -> this.rdfStream.transform(toStatement::apply), output, this.format, this.mediaType);
        }
        catch (RDFHandlerException e) {
            this.setException(e);
            LOGGER.debug("Error serializing RDF", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    private void write(Iterable<Statement> model, OutputStream output, RDFFormat dataFormat, MediaType dataMediaType) throws RDFHandlerException {
        WriterConfig settings = WriterConfigHelper.apply(dataMediaType);
        RDFWriter writer = Rio.createWriter((RDFFormat)dataFormat, (OutputStream)output);
        writer.setWriterConfig(settings);
        Maps.filterEntries((Map)this.rdfStream.namespaces(), e -> !((String)e.getKey()).equals("xmlns")).forEach(UncheckedBiConsumer.uncheck((arg_0, arg_1) -> ((RDFWriter)writer).handleNamespace(arg_0, arg_1)));
        Rio.write(model, (RDFHandler)writer);
    }

    private static Resource getResourceForSubject(Node subjectNode) {
        return subjectNode.isBlank() ? vfactory.createBNode(subjectNode.getBlankNodeLabel()) : vfactory.createURI(subjectNode.getURI());
    }

    protected static Value getValueForObject(Node object) {
        if (object.isURI()) {
            return vfactory.createURI(object.getURI());
        }
        if (object.isBlank()) {
            return vfactory.createBNode(object.getBlankNodeLabel());
        }
        if (object.isLiteral()) {
            String literalValue = object.getLiteralLexicalForm();
            String literalDatatypeURI = object.getLiteralDatatypeURI();
            if (!object.getLiteralLanguage().isEmpty()) {
                return vfactory.createLiteral(literalValue, object.getLiteralLanguage());
            }
            if (literalDatatypeURI != null) {
                URI uri = vfactory.createURI(literalDatatypeURI);
                return vfactory.createLiteral(literalValue, uri);
            }
            return Literals.createLiteral((ValueFactory)vfactory, (Object)object.getLiteralValue());
        }
        throw new AssertionError((Object)("Unable to convert " + object + " to a value, it is neither URI, blank, nor literal!"));
    }
}

