/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.hp.hpl.jena.graph.FrontsTriple;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.rdf.UriAwareResourceModelFactory;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HttpTripleUtil
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTripleUtil.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public RdfStream addHttpComponentModelsForResourceToStream(RdfStream rdfStream, FedoraResource resource, UriInfo uriInfo, IdentifierConverter<Resource, FedoraResource> idTranslator) {
        LOGGER.debug("Adding additional HTTP context triples to stream");
        return new DefaultRdfStream(rdfStream.topic(), Stream.concat(rdfStream, this.getUriAwareTripleFactories().entrySet().stream().flatMap(e -> {
            LOGGER.debug("Adding response information using: {}", e.getKey());
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(((UriAwareResourceModelFactory)e.getValue()).createModelForResource(resource, uriInfo, idTranslator).listStatements(), 1024), false).map(FrontsTriple::asTriple);
        })));
    }

    private Map<String, UriAwareResourceModelFactory> getUriAwareTripleFactories() {
        return this.applicationContext.getBeansOfType(UriAwareResourceModelFactory.class);
    }
}

