/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import com.hp.hpl.jena.query.QueryParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class QueryParseExceptionMapper
implements ExceptionMapper<QueryParseException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryParseExceptionMapper.class);

    public Response toResponse(QueryParseException e) {
        Pattern namespacePattern;
        Matcher namespaceMatch;
        LOGGER.error("Captured a query parse exception {}", (Object)e.getMessage());
        if (e.getMessage().matches(".* Unresolved prefixed name: .*") && (namespaceMatch = (namespacePattern = Pattern.compile("Unresolved prefixed name: (\\w+:\\w+)")).matcher(e.getMessage())).find()) {
            String msg = String.format("There are one or more undefined namespace(s) in your request [ %s ], please define them before retrying", namespaceMatch.group(1));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
    }
}

