/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.jersey.message.internal.HttpHeaderReader;

public class PreferTag
implements Comparable<PreferTag> {
    private final String tag;
    private String value = "";
    private Map<String, String> params = new HashMap<String, String>();

    public static PreferTag emptyTag() {
        return new PreferTag((String)null);
    }

    public PreferTag(PreferTag preferTag) {
        this.tag = preferTag.getTag();
        this.value = preferTag.getValue();
        this.params = preferTag.getParams();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreferTag(HttpHeaderReader reader) {
        reader.hasNext();
        if (reader.hasNext()) {
            try {
                this.tag = Optional.ofNullable(reader.nextToken()).map(CharSequence::toString).orElse(null);
                if (reader.hasNextSeparator('=', true)) {
                    reader.next();
                    this.value = Optional.ofNullable(reader.nextTokenOrQuotedString()).map(CharSequence::toString).orElse(null);
                }
                if (!reader.hasNext()) return;
                this.params = HttpHeaderReader.readParameters((HttpHeaderReader)reader);
                if (this.params != null) return;
                this.params = new HashMap<String, String>();
                return;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse 'Prefer' header", e);
            }
        } else {
            this.tag = "";
        }
    }

    public PreferTag(String inputTag) {
        this(HttpHeaderReader.newInstance((String)inputTag));
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void addResponseHeaders(HttpServletResponse servletResponse) {
        if (!this.value.equals("minimal")) {
            servletResponse.addHeader("Preference-Applied", "return=representation");
        } else {
            servletResponse.addHeader("Preference-Applied", "return=minimal");
        }
        servletResponse.addHeader("Vary", "Prefer");
    }

    @Override
    public int compareTo(PreferTag otherTag) {
        return this.getTag().compareTo(otherTag.getTag());
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PreferTag) {
            return this.getTag().equals(((PreferTag)obj).getTag());
        }
        return false;
    }

    public int hashCode() {
        if (this.getTag() == null) {
            return 0;
        }
        return this.getTag().hashCode();
    }
}

