/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api;

import com.google.common.collect.Multimap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.api.UriAwareHttpHeaderFactory;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Component;

@Component
public class HttpHeaderInjector
extends ApplicationObjectSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderInjector.class);
    private ApplicationContext applicationContext;

    protected void initApplicationContext() throws BeansException {
        this.applicationContext = this.getApplicationContext();
    }

    protected boolean isContextRequired() {
        return true;
    }

    public void addHttpHeaderToResponseStream(HttpServletResponse servletResponse, UriInfo uriInfo, FedoraResource resource) {
        this.getUriAwareHttpHeaderFactories().forEach((bean, factory) -> {
            LOGGER.debug("Adding HTTP headers using: {}", bean);
            Multimap<String, String> h = factory.createHttpHeadersForResource(uriInfo, resource);
            h.entries().forEach(entry -> servletResponse.addHeader((String)entry.getKey(), (String)entry.getValue()));
        });
    }

    private Map<String, UriAwareHttpHeaderFactory> getUriAwareHttpHeaderFactories() {
        return this.applicationContext.getBeansOfType(UriAwareHttpHeaderFactory.class);
    }
}

