/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import java.security.Principal;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.exception.SessionMissingException;
import org.fcrepo.kernel.api.services.CredentialsService;
import org.fcrepo.kernel.api.services.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFactory.class);
    @Inject
    private Repository repo;
    @Inject
    private TransactionService transactionService;
    @Inject
    private CredentialsService credentialsService;

    public SessionFactory() {
    }

    public SessionFactory(Repository repo, TransactionService transactionService) {
        this.repo = repo;
        this.transactionService = transactionService;
    }

    @PostConstruct
    public void init() {
        Objects.requireNonNull(this.repo, "SessionFactory requires a Repository instance!");
    }

    public Session getInternalSession() {
        try {
            return this.repo.login();
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public Session getSession(HttpServletRequest servletRequest) {
        Session session;
        String txId = this.getEmbeddedId(servletRequest, Prefix.TX);
        try {
            session = txId == null ? this.createSession(servletRequest) : this.getSessionFromTransaction(servletRequest, txId);
        }
        catch (SessionMissingException e) {
            LOGGER.warn("Transaction missing: {}", (Object)e.getMessage());
            return null;
        }
        catch (RepositoryException e) {
            throw new BadRequestException((Throwable)e);
        }
        return session;
    }

    protected Session createSession(HttpServletRequest servletRequest) throws RepositoryException {
        LOGGER.debug("Returning an authenticated session in the default workspace");
        return this.repo.login(this.credentialsService.getCredentials((Object)servletRequest));
    }

    protected Session getSessionFromTransaction(HttpServletRequest servletRequest, String txId) {
        Principal userPrincipal = servletRequest.getUserPrincipal();
        String userName = null;
        if (userPrincipal != null) {
            userName = userPrincipal.getName();
        }
        Transaction transaction = this.transactionService.getTransaction(txId, userName);
        LOGGER.debug("Returning a session in the transaction {} for user {}", (Object)transaction, (Object)userName);
        return transaction.getSession();
    }

    protected String getEmbeddedId(HttpServletRequest servletRequest, Prefix prefix) {
        String requestPath = servletRequest.getPathInfo();
        if (requestPath == null && servletRequest.getContextPath().isEmpty()) {
            requestPath = servletRequest.getRequestURI();
        }
        String id = null;
        if (requestPath != null) {
            String pathPrefix = prefix.getPrefix();
            String[] part = requestPath.split("/");
            if (part.length > 1 && part[1].startsWith(pathPrefix)) {
                id = part[1].substring(pathPrefix.length());
            }
        }
        return id;
    }

    protected static enum Prefix {
        TX("tx:");

        private final String prefix;

        private Prefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

