/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.google.common.collect.ImmutableBiMap;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.fcrepo.http.commons.api.rdf.HttpTripleUtil;
import org.fcrepo.http.commons.api.rdf.UriAwareResourceModelFactory;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.modeshape.FedoraResourceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpTripleUtilTest {
    private HttpTripleUtil testObj;
    @Mock
    private UriInfo mockUriInfo;
    @Mock
    private IdentifierConverter<Resource, FedoraResource> mockSubjects;
    @Mock
    private UriAwareResourceModelFactory mockBean1;
    @Mock
    private UriAwareResourceModelFactory mockBean2;
    @Mock
    private ApplicationContext mockContext;
    @Mock
    private FedoraResourceImpl mockResource;

    @Before
    public void setUp() {
        this.testObj = new HttpTripleUtil();
        this.testObj.setApplicationContext(this.mockContext);
    }

    @Test
    public void shouldAddTriplesFromRegisteredBeans() {
        ImmutableBiMap mockBeans = ImmutableBiMap.of((Object)"doesnt", (Object)this.mockBean1, (Object)"matter", (Object)this.mockBean2);
        Mockito.when((Object)this.mockContext.getBeansOfType(UriAwareResourceModelFactory.class)).thenReturn((Object)mockBeans);
        Mockito.when((Object)this.mockBean1.createModelForResource((FedoraResource)Matchers.eq((Object)this.mockResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (IdentifierConverter)Matchers.eq(this.mockSubjects))).thenReturn((Object)ModelFactory.createDefaultModel());
        Mockito.when((Object)this.mockBean2.createModelForResource((FedoraResource)Matchers.eq((Object)this.mockResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (IdentifierConverter)Matchers.eq(this.mockSubjects))).thenReturn((Object)ModelFactory.createDefaultModel());
        try (DefaultRdfStream rdfStream = new DefaultRdfStream(NodeFactory.createURI((String)"info:subject"));){
            Assert.assertTrue((this.testObj.addHttpComponentModelsForResourceToStream((RdfStream)rdfStream, (FedoraResource)this.mockResource, this.mockUriInfo, this.mockSubjects).count() >= 0L ? 1 : 0) != 0);
            ((UriAwareResourceModelFactory)Mockito.verify((Object)this.mockBean1)).createModelForResource((FedoraResource)Matchers.eq((Object)this.mockResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (IdentifierConverter)Matchers.eq(this.mockSubjects));
            ((UriAwareResourceModelFactory)Mockito.verify((Object)this.mockBean2)).createModelForResource((FedoraResource)Matchers.eq((Object)this.mockResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (IdentifierConverter)Matchers.eq(this.mockSubjects));
        }
    }
}

