/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Range {
    private final long start;
    private final long end;
    private static Pattern rangePattern = Pattern.compile("^bytes\\s*=\\s*(\\d*)\\s*-\\s*(\\d*)");

    public Range() {
        this(0L, -1L);
    }

    public Range(long start) {
        this(start, -1L);
    }

    public Range(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public boolean hasRange() {
        return this.start != 0L || this.end != -1L;
    }

    public long size() {
        if (this.end == -1L) {
            return -1L;
        }
        return this.end - this.start + 1L;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public static Range convert(String source) {
        Matcher matcher = rangePattern.matcher(source);
        if (!matcher.matches()) {
            return new Range();
        }
        String from = matcher.group(1);
        String to = matcher.group(2);
        long start = from.equals("") ? 0L : Long.parseLong(from);
        long end = to.equals("") ? -1L : Long.parseLong(to);
        return new Range(start, end);
    }
}

