/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.jcr.Session;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.RiotException;
import org.fcrepo.http.commons.domain.RDFMediaType;
import org.fcrepo.http.commons.responses.RdfStreamStreamingOutput;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class RdfStreamStreamingOutputTest {
    private RdfStreamStreamingOutput testRdfStreamStreamingOutput;
    private static final Triple triple = Triple.create((Node)NodeFactory.createURI((String)"info:testSubject"), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)NodeFactory.createURI((String)"info:testObject"));
    @Mock
    private Node mockNode;
    private final RdfStream testRdfStream = new DefaultRdfStream(triple.getSubject(), Stream.of(triple));
    private final Map<String, String> testNamespaces = new HashMap<String, String>();
    @Mock
    private RdfStream mockRdfStream;
    @Mock
    private Session mockSession;
    private final MediaType testMediaType = MediaType.valueOf((String)"application/rdf+xml");
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamStreamingOutputTest.class);

    @Before
    public void setUp() {
        this.testRdfStreamStreamingOutput = new RdfStreamStreamingOutput(this.testRdfStream, this.testNamespaces, this.testMediaType);
    }

    @Test
    public void testWrite() throws IOException {
        this.assertOutputContainsTriple(triple);
    }

    public void assertOutputContainsTriple(Triple expected) throws IOException {
        try (DefaultRdfStream input = new DefaultRdfStream(expected.getSubject(), Stream.of(expected));
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput((RdfStream)input, this.testNamespaces, this.testMediaType).write((OutputStream)output);
            try (ByteArrayInputStream resultStream = new ByteArrayInputStream(output.toByteArray());){
                Model result = ModelFactory.createDefaultModel().read((InputStream)resultStream, null);
                Assert.assertTrue((String)"Didn't find our test triple!", (boolean)result.contains(result.asStatement(expected)));
            }
        }
    }

    @Test
    public void testWriteWithNamespace() throws IOException {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("a", "info:a");
        try (DefaultRdfStream input = new DefaultRdfStream(triple.getSubject(), Stream.of(triple));
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput((RdfStream)input, namespaces, RDFMediaType.TURTLE_TYPE).write((OutputStream)output);
            String s = output.toString("UTF-8");
            Assert.assertTrue((boolean)s.replaceAll("\\s+", " ").contains("@prefix a: <info:a>"));
        }
    }

    @Test
    public void testWriteWithTypedObject() throws IOException {
        this.assertOutputContainsTriple(Triple.create((Node)NodeFactory.createURI((String)"info:testSubject"), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)ResourceFactory.createTypedLiteral((Object)0).asNode()));
    }

    @Test
    public void testWriteWithBlankSubject() throws IOException {
        try (DefaultRdfStream input = new DefaultRdfStream(ResourceFactory.createResource().asNode(), Stream.of(Triple.create((Node)ResourceFactory.createResource().asNode(), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)ResourceFactory.createTypedLiteral((Object)0).asNode())));
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput((RdfStream)input, this.testNamespaces, this.testMediaType).write((OutputStream)output);
            try (ByteArrayInputStream resultStream = new ByteArrayInputStream(output.toByteArray());){
                Model result = ModelFactory.createDefaultModel().read((InputStream)resultStream, null);
                Assert.assertTrue((boolean)result.contains(null, ResourceFactory.createProperty((String)"info:testPredicate"), (RDFNode)ResourceFactory.createTypedLiteral((Object)0)));
            }
        }
    }

    @Test
    public void testWriteWithBlankObject() throws IOException {
        Stream<Triple> triples = Stream.of(Triple.create((Node)ResourceFactory.createResource().asNode(), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)ResourceFactory.createResource().asNode()));
        try (DefaultRdfStream input = new DefaultRdfStream(ResourceFactory.createResource().asNode(), triples);
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            new RdfStreamStreamingOutput((RdfStream)input, this.testNamespaces, this.testMediaType).write((OutputStream)output);
            try (ByteArrayInputStream resultStream = new ByteArrayInputStream(output.toByteArray());){
                Model result = ModelFactory.createDefaultModel().read((InputStream)resultStream, null);
                Assert.assertTrue((boolean)result.contains(null, ResourceFactory.createProperty((String)"info:testPredicate"), (RDFNode)null));
            }
        }
    }

    @Test
    public void testWriteWithDatetimeObject() throws IOException {
        this.assertOutputContainsTriple(Triple.create((Node)NodeFactory.createURI((String)"info:testSubject"), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)NodeFactory.createLiteral((String)"2014-01-01T01:02:03Z", (RDFDatatype)XSDDatatype.XSDdateTime)));
    }

    @Test
    public void testWriteWithLanguageLiteral() throws IOException {
        this.assertOutputContainsTriple(Triple.create((Node)NodeFactory.createURI((String)"info:testSubject"), (Node)NodeFactory.createURI((String)"info:testPredicate"), (Node)NodeFactory.createLiteral((String)"french string", (String)"fr")));
    }

    @Test(expected=WebApplicationException.class)
    public void testWriteWithException() throws IOException {
        FutureCallback<Void> callback = new FutureCallback<Void>(){

            public void onSuccess(Void v) {
                throw new AssertionError((Object)"Should never happen!");
            }

            public void onFailure(Throwable e) {
                LOGGER.info("Got exception:", (Object)e.getMessage());
                Assert.assertTrue((String)"Got wrong kind of exception!", (boolean)(e instanceof RiotException));
            }
        };
        Futures.addCallback((ListenableFuture)this.testRdfStreamStreamingOutput, (FutureCallback)callback);
        try (OutputStream mockOutputStream = (OutputStream)Mockito.mock(OutputStream.class, invocation -> {
            throw new RiotException("Expected.");
        });){
            this.testRdfStreamStreamingOutput.write(mockOutputStream);
        }
    }
}

