/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import com.google.common.base.Throwables;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.exceptionhandlers.ExceptionDebugLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RepositoryExceptionMapper
implements ExceptionMapper<RepositoryException>,
ExceptionDebugLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryExceptionMapper.class);

    public Response toResponse(RepositoryException e) {
        LOGGER.error("Caught a repository exception: {}", (Object)e.getMessage());
        this.debugException(this, e, LOGGER);
        if (e.getMessage().matches("Error converting \".+\" from String to a Name")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        if (e instanceof ValueFormatException) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return Response.serverError().entity((Object)Throwables.getStackTraceAsString((Throwable)e)).build();
    }
}

