/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import org.fcrepo.http.commons.api.rdf.TripleOrdering;
import org.fcrepo.kernel.api.RdfLexicon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewHelpers.class);
    private static ViewHelpers instance = null;
    private static final List<Property> TITLE_PROPERTIES = Arrays.asList(RDFS.label, DC.title, DCTerms.title, SKOS.prefLabel);
    private static final String DEFAULT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("GMT")).format(Instant.now());

    private ViewHelpers() {
    }

    public static ViewHelpers getInstance() {
        return instance == null ? (instance = new ViewHelpers()) : instance;
    }

    public Iterator<Node> getVersions(Graph graph, Node subject) {
        return this.getOrderedVersions(graph, subject, (Resource)RdfLexicon.HAS_VERSION);
    }

    public Iterator<Node> getOrderedVersions(Graph g, Node subject, Resource predicate) {
        List vs = GraphUtil.listObjects((Graph)g, (Node)subject, (Node)predicate.asNode()).toList();
        vs.sort((v1, v2) -> this.getVersionDate(g, (Node)v1).orElse(DEFAULT).compareTo(this.getVersionDate(g, (Node)v2).orElse(DEFAULT)));
        return vs.iterator();
    }

    public String getVersionSubjectUrl(UriInfo uriInfo, Node subject) {
        Map<String, String> breadcrumbs = this.getNodeBreadcrumbs(uriInfo, subject);
        String lastUrl = null;
        for (Map.Entry<String, String> entry : breadcrumbs.entrySet()) {
            if (entry.getValue().equals("fcr:versions")) {
                return lastUrl;
            }
            lastUrl = entry.getKey();
        }
        return null;
    }

    public Optional<String> getVersionLabel(Graph graph, Node subject) {
        return ViewHelpers.getValue(graph, subject, RdfLexicon.HAS_VERSION_LABEL.asNode());
    }

    public Optional<String> getVersionDate(Graph graph, Node subject) {
        return ViewHelpers.getValue(graph, subject, RdfLexicon.CREATED_DATE.asNode());
    }

    private static Optional<String> getValue(Graph graph, Node subject, Node predicate) {
        ExtendedIterator objects = GraphUtil.listObjects((Graph)graph, (Node)subject, (Node)predicate);
        return Optional.ofNullable(objects.hasNext() ? ((Node)objects.next()).getLiteralValue().toString() : null);
    }

    public String getObjectTitle(Graph graph, Node sub) {
        if (sub == null) {
            return "";
        }
        Optional<String> title = TITLE_PROPERTIES.stream().map(FrontsNode::asNode).flatMap(p -> GraphUtil.listObjects((Graph)graph, (Node)sub, (Node)p).toList().stream()).filter(Node::isLiteral).map(Node::getLiteral).map(LiteralLabel::toString).findFirst();
        return title.orElse(sub.isURI() ? sub.getURI() : (sub.isBlank() ? sub.getBlankNodeLabel() : sub.toString()));
    }

    public boolean isWritable(Graph graph, Node subject) {
        return ViewHelpers.getValue(graph, subject, RdfLexicon.WRITABLE.asNode()).filter("true"::equals).isPresent();
    }

    public boolean isVersionedNode(Graph graph, Node subject) {
        return GraphUtil.listObjects((Graph)graph, (Node)subject, (Node)RDF.type.asNode()).toList().stream().map(Node::getURI).anyMatch("http://fedora.info/definitions/v4/repository#Version"::equals);
    }

    public String getObjectsAsString(Graph graph, Node subject, Resource predicate, boolean uriAsLink) {
        LOGGER.trace("Getting Objects as String: s:{}, p:{}, g:{}", new Object[]{subject, predicate, graph});
        ExtendedIterator iterator = GraphUtil.listObjects((Graph)graph, (Node)subject, (Node)predicate.asNode());
        if (iterator.hasNext()) {
            Node obj = (Node)iterator.next();
            if (obj.isLiteral()) {
                String lit = obj.getLiteralValue().toString();
                return lit.isEmpty() ? "<empty>" : lit;
            }
            return uriAsLink ? "&lt;<a href=\"" + obj.getURI() + "\">" + obj.getURI() + "</a>&gt;" : obj.getURI();
        }
        return "";
    }

    public int getNumChildren(Graph graph, Node subject) {
        LOGGER.trace("Getting number of children: s:{}, g:{}", (Object)subject, (Object)graph);
        return (int)Iter.asStream((Iterator)GraphUtil.listObjects((Graph)graph, (Node)subject, (Node)RdfLexicon.CONTAINS.asNode())).count();
    }

    public Map<String, String> getNodeBreadcrumbs(UriInfo uriInfo, Node subject) {
        String topic = subject.getURI();
        LOGGER.trace("Generating breadcrumbs for subject {}", (Object)subject);
        String baseUri = uriInfo.getBaseUri().toString();
        if (!topic.startsWith(baseUri)) {
            LOGGER.trace("Topic wasn't part of our base URI {}", (Object)baseUri);
            return Collections.emptyMap();
        }
        String salientPath = topic.substring(baseUri.length());
        StringJoiner cumulativePath = new StringJoiner("/");
        return Arrays.stream(salientPath.split("/")).filter(seg -> !seg.isEmpty()).collect(Collectors.toMap(seg -> uriInfo.getBaseUriBuilder().path(cumulativePath.add((CharSequence)seg).toString()).build(new Object[0]).toString(), seg -> seg, (u, v) -> null, LinkedHashMap::new));
    }

    public List<Triple> getSortedTriples(Model model, Iterator<Triple> it) {
        ArrayList triples = Lists.newArrayList(it);
        triples.sort(new TripleOrdering((PrefixMapping)model));
        return triples;
    }

    public String getNamespacePrefix(PrefixMapping mapping, String ns, boolean compact) {
        String nsURIPrefix = mapping.getNsURIPrefix(ns);
        if (nsURIPrefix == null) {
            if (compact) {
                int hashIdx = ns.lastIndexOf(35);
                int split = hashIdx > 0 ? ns.substring(0, hashIdx).lastIndexOf(47) : ns.lastIndexOf(47);
                return split > 0 ? "..." + ns.substring(split) : ns;
            }
            return ns;
        }
        return nsURIPrefix + ":";
    }

    public String getPrefixPreamble(PrefixMapping mapping) {
        return mapping.getNsPrefixMap().entrySet().stream().map(e -> "PREFIX " + (String)e.getKey() + ": <" + (String)e.getValue() + ">").collect(Collectors.joining("\n", "", "\n\n"));
    }

    public boolean isRdfResource(Graph graph, Node subject, String namespace, String resource) {
        LOGGER.trace("Is RDF Resource? s:{}, ns:{}, r:{}, g:{}", new Object[]{subject, namespace, resource, graph});
        return graph.find(subject, RDF.type.asNode(), ResourceFactory.createResource((String)(namespace + resource)).asNode()).hasNext();
    }

    public Node asLiteralStringNode(String r) {
        return ResourceFactory.createPlainLiteral((String)r).asNode();
    }

    public int addOne(int i) {
        return i + 1;
    }

    public Property rdfType() {
        return RDF.type;
    }

    public Property rdfsDomain() {
        return RDFS.domain;
    }

    public Resource rdfsClass() {
        return RDFS.Class;
    }

    public static Node getContentNode(Node subject) {
        return subject == null ? null : NodeFactory.createURI((String)subject.getURI().replace("/fcr:metadata", ""));
    }

    public static Node createURI(String uri) {
        return NodeFactory.createURI((String)uri);
    }

    public static String parameterize(String source) {
        return source.toLowerCase().replaceAll("[^a-z0-9\\-_]+", "_");
    }

    public static boolean isManagedProperty(Node property) {
        return property.isURI() && RdfLexicon.isManagedPredicate.test(ResourceFactory.createProperty((String)property.getURI()));
    }
}

