/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import com.google.common.base.Throwables;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.exceptionhandlers.ExceptionDebugLogging;
import org.fcrepo.http.commons.exceptionhandlers.RepositoryExceptionMapper;
import org.fcrepo.http.commons.exceptionhandlers.SessionMissingExceptionMapper;
import org.fcrepo.kernel.api.exception.SessionMissingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WildcardExceptionMapper
implements ExceptionMapper<Exception>,
ExceptionDebugLogging {
    Boolean showStackTrace = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(WildcardExceptionMapper.class);

    public Response toResponse(Exception e) {
        if (e.getCause() instanceof SessionMissingException) {
            return new SessionMissingExceptionMapper().toResponse((SessionMissingException)e.getCause());
        }
        if (e.getCause() instanceof RepositoryException) {
            return new RepositoryExceptionMapper().toResponse((RepositoryException)e.getCause());
        }
        LOGGER.error("Exception intercepted by WildcardExceptionMapper: {}\n", (Object)e.getMessage());
        this.debugException(this, e, LOGGER);
        return Response.serverError().entity((Object)(this.showStackTrace != false ? Throwables.getStackTraceAsString((Throwable)e) : null)).build();
    }

    public void setShowStackTrace(Boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }
}

