/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.util.concurrent.AbstractFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.fcrepo.kernel.api.RdfCollectors;
import org.fcrepo.kernel.api.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfStreamStreamingOutput
extends AbstractFuture<Void>
implements StreamingOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamStreamingOutput.class);
    private static final String JSONLD_COMPACTED = "http://www.w3.org/ns/json-ld#compacted";
    private static final String JSONLD_FLATTENED = "http://www.w3.org/ns/json-ld#flattened";
    private final Lang format;
    private final MediaType mediaType;
    private final RdfStream rdfStream;
    private final Map<String, String> namespaces;

    public RdfStreamStreamingOutput(RdfStream rdfStream, Map<String, String> namespaces, MediaType mediaType) {
        Lang format2;
        if (LOGGER.isDebugEnabled()) {
            RDFLanguages.getRegisteredLanguages().forEach(format -> LOGGER.debug("Discovered RDF writer writeableFormats: {} with mimeTypes: {}", (Object)format.getName(), (Object)String.join((CharSequence)" ", format.getAltContentTypes())));
        }
        if ((format2 = RDFLanguages.contentTypeToLang((String)(mediaType.getType() + "/" + mediaType.getSubtype()))) == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        this.format = format2;
        this.mediaType = mediaType;
        LOGGER.debug("Setting up to serialize to: {}", (Object)format2);
        this.rdfStream = rdfStream;
        this.namespaces = namespaces;
    }

    public void write(OutputStream output) {
        try {
            LOGGER.debug("Serializing RDF stream in: {}", (Object)this.format);
            RdfStreamStreamingOutput.write(this.rdfStream, output, this.format, this.mediaType, this.namespaces);
        }
        catch (IOException | RiotException e) {
            this.setException(e);
            LOGGER.debug("Error serializing RDF", (Object)e.getMessage());
            throw new WebApplicationException(e);
        }
    }

    private static void write(RdfStream rdfStream, OutputStream output, Lang dataFormat, MediaType dataMediaType, Map<String, String> nsPrefixes) throws IOException {
        RDFFormat format = StreamRDFWriter.defaultSerialization((Lang)dataFormat);
        if (format != null) {
            LOGGER.debug("Stream-based serialization of {}", (Object)dataFormat.toString());
            StreamRDF stream = StreamRDFWriter.getWriterStream((OutputStream)output, (RDFFormat)format);
            stream.start();
            nsPrefixes.forEach((arg_0, arg_1) -> ((StreamRDF)stream).prefix(arg_0, arg_1));
            rdfStream.forEach(arg_0 -> ((StreamRDF)stream).triple(arg_0));
            stream.finish();
        } else {
            LOGGER.debug("Non-stream serialization of {}", (Object)dataFormat.toString());
            Model model = (Model)rdfStream.collect(RdfCollectors.toModel());
            model.setNsPrefixes(nsPrefixes);
            if (Lang.RDFXML.equals((Object)dataFormat)) {
                RDFDataMgr.write((OutputStream)output, (Graph)model.getGraph(), (RDFFormat)RDFFormat.RDFXML_PLAIN);
            } else if (Lang.JSONLD.equals((Object)dataFormat)) {
                RDFFormat jsonldFormat = RdfStreamStreamingOutput.getFormatFromMediaType(dataMediaType);
                RDFDataMgr.write((OutputStream)output, (Graph)model.getGraph(), (RDFFormat)jsonldFormat);
            } else {
                RDFDataMgr.write((OutputStream)output, (Graph)model.getGraph(), (Lang)dataFormat);
            }
        }
    }

    private static RDFFormat getFormatFromMediaType(MediaType mediaType) {
        String profile = mediaType.getParameters().getOrDefault("profile", "");
        if (profile.equals(JSONLD_COMPACTED)) {
            return RDFFormat.JSONLD_COMPACT_FLAT;
        }
        if (profile.equals(JSONLD_FLATTENED)) {
            return RDFFormat.JSONLD_FLATTEN_FLAT;
        }
        return RDFFormat.JSONLD_EXPAND_FLAT;
    }
}

