/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.stream.Stream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.fcrepo.http.commons.responses.RdfNamespacedStream;
import org.fcrepo.http.commons.responses.RdfStreamProvider;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RdfStreamProviderTest {
    private final RdfStreamProvider testProvider = new RdfStreamProvider();
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;

    @Before
    public void setUp() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefixes()).thenReturn((Object)new String[0]);
    }

    @Test
    public void testGetSize() {
        Assert.assertEquals((long)-1L, (long)this.testProvider.getSize(null, null, null, null, null));
    }

    @Test
    public void testIsWriteable() {
        Assert.assertTrue((String)"Should be able to serialize this!", (boolean)this.testProvider.isWriteable(RdfNamespacedStream.class, null, null, MediaType.valueOf((String)"application/rdf+xml")));
        Assert.assertFalse((String)"Should not be able to serialize this!", (boolean)this.testProvider.isWriteable(RdfStream.class, null, null, MediaType.valueOf((String)"application/rdf+xml")));
        Assert.assertFalse((String)"Should not be able to serialize this!", (boolean)this.testProvider.isWriteable(RdfStreamProviderTest.class, null, null, MediaType.valueOf((String)"application/rdf+xml")));
        Assert.assertFalse((String)"Should not be able to serialize this!", (boolean)this.testProvider.isWriteable(RdfStream.class, null, null, MediaType.valueOf((String)"text/html")));
    }

    @Test
    public void testWriteTo() throws WebApplicationException, IllegalArgumentException, IOException {
        Triple t = Triple.create((Node)NodeFactory.createURI((String)"info:test"), (Node)NodeFactory.createURI((String)"property:test"), (Node)NodeFactory.createURI((String)"info:test"));
        HashMap namespaces = new HashMap();
        try (DefaultRdfStream rdfStream = new DefaultRdfStream(NodeFactory.createURI((String)"info:test"), Stream.of(t));
             RdfNamespacedStream nsStream = new RdfNamespacedStream((RdfStream)rdfStream, namespaces);
             ByteArrayOutputStream entityStream = new ByteArrayOutputStream();){
            this.testProvider.writeTo(nsStream, RdfNamespacedStream.class, null, null, MediaType.valueOf((String)"application/rdf+xml"), null, (OutputStream)entityStream);
            byte[] result = entityStream.toByteArray();
            Model postSerialization = ModelFactory.createDefaultModel().read((InputStream)new ByteArrayInputStream(result), null);
            Assert.assertTrue((String)"Didn't find our triple!", (boolean)postSerialization.contains(postSerialization.asStatement(t)));
        }
    }
}

