/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import java.security.Principal;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.http.commons.session.HttpSession;
import org.fcrepo.kernel.api.FedoraRepository;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.exception.SessionMissingException;
import org.fcrepo.kernel.api.services.BatchService;
import org.fcrepo.kernel.api.services.CredentialsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFactory.class);
    @Inject
    private FedoraRepository repo;
    @Inject
    private BatchService batchService;
    @Inject
    private CredentialsService credentialsService;

    public SessionFactory() {
    }

    public SessionFactory(FedoraRepository repo, BatchService batchService) {
        this.repo = repo;
        this.batchService = batchService;
    }

    @PostConstruct
    public void init() {
        Objects.requireNonNull(this.repo, "SessionFactory requires a Repository instance!");
    }

    public FedoraSession getInternalSession() {
        return this.repo.login();
    }

    public HttpSession getSession(HttpServletRequest servletRequest) {
        HttpSession session;
        String txId = this.getEmbeddedId(servletRequest, Prefix.TX);
        try {
            session = txId == null ? this.createSession(servletRequest) : this.getSessionFromTransaction(servletRequest, txId);
        }
        catch (SessionMissingException e) {
            LOGGER.warn("Transaction missing: {}", (Object)e.getMessage());
            return null;
        }
        return session;
    }

    protected HttpSession createSession(HttpServletRequest servletRequest) {
        LOGGER.debug("Returning an authenticated session in the default workspace");
        return new HttpSession(this.repo.login(this.credentialsService.getCredentials((Object)servletRequest)));
    }

    protected HttpSession getSessionFromTransaction(HttpServletRequest servletRequest, String txId) {
        Principal userPrincipal = servletRequest.getUserPrincipal();
        String userName = userPrincipal == null ? null : userPrincipal.getName();
        FedoraSession session = this.batchService.getSession(txId, userName);
        HttpSession batchSession = new HttpSession(session);
        batchSession.makeBatchSession();
        LOGGER.debug("Returning a session in the batch {} for user {}", (Object)batchSession, (Object)userName);
        return batchSession;
    }

    protected String getEmbeddedId(HttpServletRequest servletRequest, Prefix prefix) {
        String requestPath = servletRequest.getPathInfo();
        if (requestPath == null && servletRequest.getContextPath().isEmpty()) {
            requestPath = servletRequest.getRequestURI();
        }
        String id = null;
        if (requestPath != null) {
            String pathPrefix = prefix.getPrefix();
            String[] part = requestPath.split("/");
            if (part.length > 1 && part[1].startsWith(pathPrefix)) {
                id = part[1].substring(pathPrefix.length());
            }
        }
        return id;
    }

    protected static enum Prefix {
        TX("tx:");

        private final String prefix;

        private Prefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

