/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.codec.binary.Base64;
import org.fcrepo.http.commons.exceptionhandlers.ExceptionDebugLogging;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class MalformedRdfExceptionMapper
implements ExceptionMapper<MalformedRdfException>,
ExceptionDebugLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(MalformedRdfExceptionMapper.class);
    private static final int REASONABLE_LENGTH = 500;

    public Response toResponse(MalformedRdfException e) {
        this.debugException(this, (Throwable)e, LOGGER);
        Link link = Link.fromUri((String)MalformedRdfExceptionMapper.getConstraintUri(e)).rel(RdfLexicon.CONSTRAINED_BY.getURI()).build(new Object[0]);
        String msg = e.getMessage();
        if (msg.matches(".*org.*Exception: .*")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg.replaceAll("org.*Exception: ", "")).links(new Link[]{link}).type("text/plain;charset=utf-8").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).links(new Link[]{link}).type("text/plain;charset=utf-8").build();
    }

    private static String getConstraintUri(MalformedRdfException e) {
        int index = Math.min(e.getMessage().length(), 500);
        if (index > e.getMessage().length()) {
            LOGGER.debug("Truncating Link header to {} characters.", (Object)500);
        }
        return "data:text/plain;base64," + Base64.encodeBase64String((byte[])e.getMessage().substring(0, index).getBytes());
    }
}

