/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain.ldp;

import java.text.ParseException;
import org.fcrepo.http.commons.domain.PreferTag;
import org.fcrepo.http.commons.domain.ldp.LdpPreferTag;
import org.fcrepo.kernel.api.RdfLexicon;
import org.junit.Assert;
import org.junit.Test;

public class LdpPreferTagTest {
    private LdpPreferTag testObj;

    @Test
    public void testMinimalHandling() throws ParseException {
        this.testObj = new LdpPreferTag(new PreferTag("handling=lenient; received=\"minimal\""));
        Assert.assertFalse((boolean)this.testObj.prefersServerManaged());
        Assert.assertFalse((boolean)this.testObj.prefersContainment());
        Assert.assertFalse((boolean)this.testObj.prefersMembership());
        Assert.assertFalse((boolean)this.testObj.prefersEmbed());
        Assert.assertFalse((boolean)this.testObj.prefersReferences());
    }

    @Test
    public void testMinimalContainer() throws ParseException {
        PreferTag prefer = new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMinimalContainer\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersServerManaged());
        Assert.assertFalse((boolean)this.testObj.prefersReferences());
        Assert.assertFalse((boolean)this.testObj.prefersContainment());
        Assert.assertFalse((boolean)this.testObj.prefersMembership());
        Assert.assertFalse((boolean)this.testObj.prefersEmbed());
    }

    @Test
    public void testPreferMembership() throws ParseException {
        PreferTag prefer = new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMinimalContainer http://www.w3.org/ns/ldp#PreferMembership\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersMembership());
    }

    @Test
    public void testPreferContainment() throws ParseException {
        PreferTag prefer = new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMinimalContainer http://www.w3.org/ns/ldp#PreferContainment\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersContainment());
    }

    @Test
    public void testPreferContainmentAndMembership() throws ParseException {
        PreferTag prefer = new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMembership http://www.w3.org/ns/ldp#PreferContainment\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersMembership());
        Assert.assertTrue((boolean)this.testObj.prefersContainment());
    }

    @Test
    public void testPreferOmitContainmentAndMembership() throws ParseException {
        PreferTag prefer = new PreferTag("return=representation; omit=\"http://www.w3.org/ns/ldp#PreferMembership http://www.w3.org/ns/ldp#PreferContainment\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertFalse((boolean)this.testObj.prefersMembership());
        Assert.assertFalse((boolean)this.testObj.prefersContainment());
    }

    @Test
    public void testPreferEmbed() throws ParseException {
        PreferTag prefer = new PreferTag("return=representation; include=\"" + RdfLexicon.EMBED_CONTAINS + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersEmbed());
    }

    @Test
    public void testPreferReference() throws ParseException {
        PreferTag prefer = new PreferTag("return=representation; include=\"" + RdfLexicon.INBOUND_REFERENCES + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersReferences());
    }
}

