/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.fcrepo.http.commons.responses.RangeRequestInputStream;
import org.junit.Assert;
import org.junit.Test;

public class RangeRequestInputStreamTest {
    @Test
    public void shouldLimitTheInputStream() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream("0123456789".getBytes());
        try (RangeRequestInputStream out = new RangeRequestInputStream((InputStream)in, 5L, 3L);){
            String s = IOUtils.toString((InputStream)out, (Charset)StandardCharsets.UTF_8);
            Assert.assertEquals((Object)"567", (Object)s);
        }
    }

    @Test
    public void shouldAcceptUnboundedRanges() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream("0123456789".getBytes());
        try (RangeRequestInputStream out = new RangeRequestInputStream((InputStream)in, 0L, -1L);){
            String s = IOUtils.toString((InputStream)out, (Charset)StandardCharsets.UTF_8);
            Assert.assertEquals((Object)"0123456789", (Object)s);
        }
    }

    @Test
    public void getGetLongRange() throws IOException {
        StringBuffer buf = new StringBuffer();
        while (buf.length() < 9000) {
            buf.append("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(buf.toString().getBytes());
        try (RangeRequestInputStream out = new RangeRequestInputStream((InputStream)in, 0L, 9000L);){
            Assert.assertEquals((long)9000L, (long)IOUtils.toString((InputStream)out, (Charset)StandardCharsets.UTF_8).length());
        }
    }
}

