/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.version.VersionManager;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.fcrepo.http.commons.api.rdf.HttpResourceConverter;
import org.fcrepo.http.commons.session.HttpSession;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.exception.InvalidResourceIdentifierException;
import org.fcrepo.kernel.api.models.Container;
import org.fcrepo.kernel.api.models.FedoraBinary;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.FedoraTimeMap;
import org.fcrepo.kernel.api.models.FedoraWebacAcl;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.modeshape.ContainerImpl;
import org.fcrepo.kernel.modeshape.FedoraBinaryImpl;
import org.fcrepo.kernel.modeshape.FedoraResourceImpl;
import org.fcrepo.kernel.modeshape.FedoraSessionImpl;
import org.fcrepo.kernel.modeshape.FedoraTimeMapImpl;
import org.fcrepo.kernel.modeshape.FedoraWebacAclImpl;
import org.fcrepo.kernel.modeshape.NonRdfSourceDescriptionImpl;
import org.fcrepo.kernel.modeshape.utils.FedoraTypesUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class HttpResourceConverterTest {
    @Mock
    private Session session;
    @Mock
    private Session txSession;
    @Mock
    private Node node;
    @Mock
    private Node mementoNode;
    @Mock
    private Node timeMapNode;
    @Mock
    private Node descriptionNode;
    @Mock
    private Node webacAclNode;
    @Mock
    private Property mockOriginal;
    private FedoraSession testSession;
    private FedoraSession testTxSession;
    private HttpSession testHttpSession;
    private HttpSession testHttpBatchSession;
    private HttpResourceConverter converter;
    private final String uriTemplate = "http://localhost:8080/some/{path: .*}";
    private final String path = "arbitrary/path";
    private final String resourceUri = "http://localhost:8080/some/arbitrary/path";
    private final Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path");
    private final Resource metadataResource = ResourceFactory.createResource((String)(this.resource.toString() + "/fcr:metadata"));
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private VersionManager mockVersionManager;

    @Before
    public void setUp() throws RepositoryException {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)"http://localhost:8080/some/{path: .*}");
        this.testSession = new FedoraSessionImpl(this.session);
        this.testTxSession = new FedoraSessionImpl(this.txSession);
        this.testHttpSession = new HttpSession(this.testSession);
        this.testHttpBatchSession = new HttpSession(this.testTxSession);
        this.testHttpBatchSession.makeBatchSession();
        this.converter = new HttpResourceConverter(this.testHttpSession, uriBuilder);
        Mockito.when((Object)this.session.getNode("/arbitrary/path")).thenReturn((Object)this.node);
        Mockito.when((Object)this.session.getNode("/")).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.getPath()).thenReturn((Object)"/arbitrary/path");
        Mockito.when((Object)this.node.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)false);
        Mockito.when((Object)this.descriptionNode.getPath()).thenReturn((Object)"/arbitrary/path/fedora:description");
        Mockito.when((Object)this.descriptionNode.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)true);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)this.mockVersionManager);
        Mockito.when((Object)this.mockOriginal.getNode()).thenReturn((Object)this.node);
        Mockito.when((Object)this.timeMapNode.getProperty("memento:original")).thenReturn((Object)this.mockOriginal);
        Mockito.when((Object)this.timeMapNode.isNodeType("fedora:TimeMap")).thenReturn((Object)true);
        Mockito.when((Object)this.webacAclNode.isNodeType("webac:Acl")).thenReturn((Object)true);
    }

    @Test
    public void testDoForward() {
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)this.resource);
        Assert.assertEquals((Object)this.node, (Object)FedoraTypesUtils.getJcrNode((FedoraResource)converted));
    }

    @Test
    public void testDoForwardWithDatastreamContent() throws Exception {
        Mockito.when((Object)this.node.isNodeType("fedora:Binary")).thenReturn((Object)true);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)this.resource);
        Assert.assertTrue((boolean)(converted instanceof FedoraBinary));
        Assert.assertEquals((Object)this.node, (Object)FedoraTypesUtils.getJcrNode((FedoraResource)converted));
    }

    @Test
    public void testDoForwardWithDatastreamMetadata() throws Exception {
        Mockito.when((Object)this.session.getNode("/arbitrary/path/fedora:description")).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)true);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)this.metadataResource);
        Assert.assertTrue((boolean)(converted instanceof NonRdfSourceDescription));
        Assert.assertEquals((Object)this.node, (Object)FedoraTypesUtils.getJcrNode((FedoraResource)converted));
    }

    @Test
    public void testDoForwardWithAHash() throws Exception {
        Mockito.when((Object)this.session.getNode("/arbitrary/path/#/with-a-hash")).thenReturn((Object)this.node);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path#with-a-hash"));
        Assert.assertEquals((Object)this.node, (Object)FedoraTypesUtils.getJcrNode((FedoraResource)converted));
    }

    @Test
    public void testDoForwardWithTransaction() throws Exception {
        TestHelpers.setField(this.testTxSession, "id", "xyz");
        HttpResourceConverter converter = new HttpResourceConverter(this.testHttpBatchSession, UriBuilder.fromUri((String)"http://localhost:8080/some/{path: .*}"));
        Mockito.when((Object)this.txSession.getNode("/arbitrary/path")).thenReturn((Object)this.node);
        Mockito.when((Object)this.txSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/tx:xyz/arbitrary/path");
        FedoraResource converted = (FedoraResource)converter.convert((Object)resource);
        Assert.assertEquals((Object)this.node, (Object)FedoraTypesUtils.getJcrNode((FedoraResource)converted));
    }

    @Test
    public void testDoForwardWithUuid() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/[xyz]");
        Mockito.when((Object)this.session.getNode("/[xyz]")).thenReturn((Object)this.node);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertEquals((Object)this.node, (Object)FedoraTypesUtils.getJcrNode((FedoraResource)converted));
    }

    @Test
    public void testDoForwardRoot() {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/");
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertEquals((Object)this.node, (Object)FedoraTypesUtils.getJcrNode((FedoraResource)converted));
        Assert.assertTrue((boolean)this.converter.inDomain(resource));
    }

    @Test
    public void testDoForwardRootWithoutSlash() {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some");
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertEquals((Object)this.node, (Object)FedoraTypesUtils.getJcrNode((FedoraResource)converted));
        Assert.assertTrue((boolean)this.converter.inDomain(resource));
    }

    @Test
    public void testDoBackward() {
        Resource converted = (Resource)this.converter.reverse().convert((Object)new FedoraResourceImpl(this.node));
        Assert.assertEquals((Object)this.resource, (Object)converted);
    }

    @Test
    public void testDoBackwardWithDatastreamContent() throws Exception {
        Mockito.when((Object)this.node.isNodeType("fedora:Binary")).thenReturn((Object)true);
        Resource converted = (Resource)this.converter.reverse().convert((Object)new FedoraBinaryImpl(this.node));
        Assert.assertEquals((Object)this.resource, (Object)converted);
    }

    @Test
    public void testDoBackwardWithDatastreamMetadata() {
        Resource converted = (Resource)this.converter.reverse().convert((Object)new NonRdfSourceDescriptionImpl(this.descriptionNode));
        Assert.assertEquals((Object)this.metadataResource, (Object)converted);
    }

    @Test
    public void testDoBackwardWithHash() throws Exception {
        Mockito.when((Object)this.node.getPath()).thenReturn((Object)"arbitrary/path/#/with-a-hash");
        Resource converted = (Resource)this.converter.reverse().convert((Object)new FedoraResourceImpl(this.node));
        Assert.assertEquals((Object)ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path#with-a-hash"), (Object)converted);
    }

    @Test
    public void testDoBackwardWithTransaction() throws Exception {
        TestHelpers.setField(this.testTxSession, "id", "xyz");
        HttpResourceConverter converter = new HttpResourceConverter(this.testHttpBatchSession, UriBuilder.fromUri((String)"http://localhost:8080/some/{path: .*}"));
        Mockito.when((Object)this.txSession.getNode("/arbitrary/path")).thenReturn((Object)this.node);
        Mockito.when((Object)this.txSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.node.getSession()).thenReturn((Object)this.txSession);
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/tx:xyz/arbitrary/path");
        Resource converted = (Resource)converter.reverse().convert((Object)new FedoraResourceImpl(this.node));
        Assert.assertEquals((Object)resource, (Object)converted);
    }

    @Test
    public void testToStringWithRoot() {
        Assert.assertEquals((Object)"/", (Object)this.converter.asString(ResourceFactory.createResource((String)"http://localhost:8080/some/")));
    }

    @Test(expected=InvalidResourceIdentifierException.class)
    public void testToStringWithEmptPathSegment() {
        this.converter.asString(ResourceFactory.createResource((String)"http://localhost:8080/some/test/a//b/c/d"));
    }

    @Test
    public void testDoForwardWithTimemap() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/container/fcr:versions");
        Mockito.when((Object)this.session.getNode("/container")).thenReturn((Object)this.node);
        Mockito.when((Object)this.session.getNode("/container/fedora:timemap")).thenReturn((Object)this.timeMapNode);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertTrue((String)"Converted resource must be a timemap", (boolean)(converted instanceof FedoraTimeMap));
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.timeMapNode, (Object)resultNode);
    }

    @Test
    public void testDoForwardWithBinaryTimemap() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/binary/fcr:versions");
        Mockito.when((Object)this.session.getNode("/binary")).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isNodeType("fedora:Binary")).thenReturn((Object)true);
        Mockito.when((Object)this.session.getNode("/binary/fedora:timemap")).thenReturn((Object)this.timeMapNode);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertTrue((String)"Converted resource must be a timemap", (boolean)(converted instanceof FedoraTimeMap));
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.timeMapNode, (Object)resultNode);
    }

    @Test
    public void testDoForwardWithBinaryDescriptionTimemap() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/binary/fcr:metadata/fcr:versions");
        Mockito.when((Object)this.node.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)true);
        Mockito.when((Object)this.session.getNode("/binary/fedora:description")).thenReturn((Object)this.node);
        Mockito.when((Object)this.session.getNode("/binary/fedora:description/fedora:timemap")).thenReturn((Object)this.timeMapNode);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertTrue((String)"Converted resource must be a timemap", (boolean)(converted instanceof FedoraTimeMap));
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.timeMapNode, (Object)resultNode);
    }

    @Test
    public void testDoBackWithTimemap() throws Exception {
        FedoraTimeMapImpl timemap = new FedoraTimeMapImpl(this.timeMapNode);
        Mockito.when((Object)this.timeMapNode.getPath()).thenReturn((Object)"arbitrary/path/fedora:timemap");
        Resource converted = (Resource)this.converter.reverse().convert((Object)timemap);
        Resource expectedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:versions");
        Assert.assertEquals((Object)expectedResource, (Object)converted);
    }

    @Test
    public void testDoBackWithBinaryTimemap() throws Exception {
        FedoraTimeMapImpl timemap = new FedoraTimeMapImpl(this.timeMapNode);
        Mockito.when((Object)this.timeMapNode.getPath()).thenReturn((Object)"arbitrary/path/fedora:timemap");
        Mockito.when((Object)this.node.isNodeType("fedora:Binary")).thenReturn((Object)true);
        Resource converted = (Resource)this.converter.reverse().convert((Object)timemap);
        Resource expectedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:versions");
        Assert.assertEquals((Object)expectedResource, (Object)converted);
    }

    @Test
    public void testDoBackWithBinaryDescriptionTimemap() throws Exception {
        FedoraTimeMapImpl timemap = new FedoraTimeMapImpl(this.timeMapNode);
        Mockito.when((Object)this.timeMapNode.getPath()).thenReturn((Object)"arbitrary/path/fedora:description/fedora:timemap");
        Mockito.when((Object)this.node.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)true);
        Resource converted = (Resource)this.converter.reverse().convert((Object)timemap);
        Resource expectedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:metadata/fcr:versions");
        Assert.assertEquals((Object)expectedResource, (Object)converted);
    }

    @Test
    public void testDoForwardWithMemento() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/container/fcr:versions/20180315180915");
        Mockito.when((Object)this.mementoNode.isNodeType("memento:Memento")).thenReturn((Object)true);
        Mockito.when((Object)this.session.getNode("/container/fedora:timemap/20180315180915")).thenReturn((Object)this.mementoNode);
        Mockito.when((Object)this.session.getNode("/container")).thenReturn((Object)this.node);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertTrue((String)"Converted resource must be a container", (boolean)(converted instanceof Container));
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.mementoNode, (Object)resultNode);
    }

    @Test
    public void testDoForwardWithMementoWithHash() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/container/fcr:versions/20180315180915#test");
        Mockito.when((Object)this.session.getNode("/container/fedora:timemap/20180315180915/#/test")).thenReturn((Object)this.node);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.node, (Object)resultNode);
    }

    @Test
    public void testDoForwardWithBinaryMemento() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/binary/fcr:versions/20180315180915");
        Mockito.when((Object)this.mementoNode.isNodeType("memento:Memento")).thenReturn((Object)true);
        Mockito.when((Object)this.mementoNode.isNodeType("fedora:Binary")).thenReturn((Object)true);
        Mockito.when((Object)this.session.getNode("/binary/fedora:timemap/20180315180915")).thenReturn((Object)this.mementoNode);
        Mockito.when((Object)this.session.getNode("/binary")).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isNodeType("fedora:Binary")).thenReturn((Object)true);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertTrue((String)"Converted resource must be a binary", (boolean)(converted instanceof FedoraBinary));
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.mementoNode, (Object)resultNode);
    }

    @Test
    public void testDoForwardWithBinaryDescriptionMemento() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/binary/fcr:metadata/fcr:versions/20180315180915");
        Mockito.when((Object)this.mementoNode.isNodeType("memento:Memento")).thenReturn((Object)true);
        Mockito.when((Object)this.session.getNode("/binary/fedora:description/fedora:timemap/20180315180915")).thenReturn((Object)this.mementoNode);
        Mockito.when((Object)this.session.getNode("/binary/fedora:description")).thenReturn((Object)this.node);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertTrue((String)"Converted resource must be a container", (boolean)(converted instanceof Container));
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.mementoNode, (Object)resultNode);
    }

    @Test
    public void testDoBackWithMemento() throws Exception {
        Mockito.when((Object)this.node.getPath()).thenReturn((Object)"/arbitrary/path/fedora:timemap/20180315180915");
        Mockito.when((Object)this.node.isNodeType("memento:Memento")).thenReturn((Object)true);
        ContainerImpl memento = new ContainerImpl(this.node);
        Resource converted = (Resource)this.converter.reverse().convert((Object)memento);
        Resource expectedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:versions/20180315180915");
        Assert.assertEquals((Object)expectedResource, (Object)converted);
    }

    @Test
    public void testDoBackWithBinaryMemento() throws Exception {
        Mockito.when((Object)this.node.getPath()).thenReturn((Object)"/arbitrary/path/fedora:timemap/20180315180915");
        Mockito.when((Object)this.node.isNodeType("fedora:Binary")).thenReturn((Object)true);
        Mockito.when((Object)this.node.isNodeType("memento:Memento")).thenReturn((Object)true);
        FedoraBinaryImpl memento = new FedoraBinaryImpl(this.node);
        Resource converted = (Resource)this.converter.reverse().convert((Object)memento);
        Resource expectedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:versions/20180315180915");
        Assert.assertEquals((Object)expectedResource, (Object)converted);
    }

    @Test
    public void testDoBackWithBinaryDescriptionMemento() throws Exception {
        Mockito.when((Object)this.descriptionNode.getPath()).thenReturn((Object)"/arbitrary/path/fedora:description/fedora:timemap/20180315180915");
        Mockito.when((Object)this.descriptionNode.isNodeType("memento:Memento")).thenReturn((Object)true);
        NonRdfSourceDescriptionImpl memento = new NonRdfSourceDescriptionImpl(this.descriptionNode);
        Resource converted = (Resource)this.converter.reverse().convert((Object)memento);
        Resource expectedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:metadata/fcr:versions/20180315180915");
        Assert.assertEquals((Object)expectedResource, (Object)converted);
    }

    @Test
    public void testDoForwardWithWebacAcl() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/container/fcr:acl");
        Mockito.when((Object)this.session.getNode("/container")).thenReturn((Object)this.node);
        Mockito.when((Object)this.session.getNode("/container/fedora:acl")).thenReturn((Object)this.webacAclNode);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertTrue((String)"Converted resource must be a FedoraWebacAcl", (boolean)(converted instanceof FedoraWebacAcl));
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.webacAclNode, (Object)resultNode);
    }

    @Test
    public void testDoBackWithWebacAcl() throws Exception {
        FedoraWebacAclImpl webacAcl = new FedoraWebacAclImpl(this.webacAclNode);
        Mockito.when((Object)this.webacAclNode.getPath()).thenReturn((Object)"arbitrary/path/fedora:acl");
        Resource converted = (Resource)this.converter.reverse().convert((Object)webacAcl);
        Resource expectedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:acl");
        Assert.assertEquals((Object)expectedResource, (Object)converted);
    }

    @Test
    public void testDoForwardWithWebacAclWithHash() throws Exception {
        Resource resource = ResourceFactory.createResource((String)"http://localhost:8080/some/container/fcr:acl#hash_resource");
        Mockito.when((Object)this.session.getNode("/container")).thenReturn((Object)this.node);
        Mockito.when((Object)this.session.getNode("/container/fedora:acl/#/hash_resource")).thenReturn((Object)this.webacAclNode);
        FedoraResource converted = (FedoraResource)this.converter.convert((Object)resource);
        Assert.assertTrue((String)"Converted resource must be a FedoraWebacAcl", (boolean)(converted instanceof FedoraWebacAcl));
        Node resultNode = FedoraTypesUtils.getJcrNode((FedoraResource)converted);
        Assert.assertEquals((Object)this.webacAclNode, (Object)resultNode);
    }

    @Test
    public void testDoBackWithWebacAclHash() throws Exception {
        FedoraWebacAclImpl webacAcl = new FedoraWebacAclImpl(this.webacAclNode);
        Mockito.when((Object)this.webacAclNode.getPath()).thenReturn((Object)"arbitrary/path/fedora:acl/#/hash_resource");
        Resource converted = (Resource)this.converter.reverse().convert((Object)webacAcl);
        Resource expectedResource = ResourceFactory.createResource((String)"http://localhost:8080/some/arbitrary/path/fcr:acl#hash_resource");
        Assert.assertEquals((Object)expectedResource, (Object)converted);
    }
}

