/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import org.fcrepo.http.commons.domain.PreferTag;
import org.junit.Assert;
import org.junit.Test;

public class PreferTagTest {
    @Test
    public void testEmpty() {
        PreferTag preferTag = PreferTag.emptyTag();
        Assert.assertEquals((Object)"", (Object)preferTag.getTag());
        Assert.assertEquals((Object)"", (Object)preferTag.getValue());
        Assert.assertTrue((boolean)preferTag.getParams().isEmpty());
    }

    @Test
    public void testTrailingSemicolon() {
        PreferTag preferTag = new PreferTag("foo=bar;");
        Assert.assertNotNull((Object)preferTag.getParams());
    }

    @Test
    public void testEquals() {
        PreferTag preferTag1 = new PreferTag("handling=lenient; received=\"minimal\"");
        PreferTag preferTag2 = new PreferTag("handling=lenient; received=\"minimal\"");
        PreferTag preferTag3 = PreferTag.emptyTag();
        Assert.assertTrue((boolean)preferTag1.equals((Object)preferTag2));
        Assert.assertTrue((boolean)preferTag1.equals((Object)preferTag1));
        Assert.assertTrue((boolean)preferTag2.equals((Object)preferTag1));
        Assert.assertFalse((boolean)preferTag1.equals((Object)preferTag3));
        Assert.assertFalse((boolean)preferTag1.equals(null));
        Assert.assertFalse((boolean)preferTag1.equals((Object)"some string"));
    }

    @Test
    public void testHashCode() {
        PreferTagTest.doTestHashCode(new PreferTag("handling=lenient; received=\"minimal\""), new PreferTag("handling=lenient; received=\"minimal\""), true);
        PreferTagTest.doTestHashCode(new PreferTag("handling=lenient; received=\"minimal\""), new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMinimalContainer\""), false);
        PreferTagTest.doTestHashCode(new PreferTag("handling=lenient; received=\"minimal\""), PreferTag.emptyTag(), false);
    }

    private static void doTestHashCode(PreferTag tag0, PreferTag tag1, boolean expectEqual) {
        Assert.assertEquals((Object)expectEqual, (Object)tag0.equals((Object)tag1));
        Assert.assertEquals((Object)expectEqual, (Object)(tag0.hashCode() == tag1.hashCode() ? 1 : 0));
    }
}

