/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import com.google.common.base.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.fcrepo.http.commons.session.HttpSession;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.exception.IdentifierConversionException;
import org.fcrepo.kernel.api.exception.InvalidResourceIdentifierException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.exception.TombstoneException;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.modeshape.FedoraSessionImpl;
import org.fcrepo.kernel.modeshape.TombstoneImpl;
import org.fcrepo.kernel.modeshape.identifiers.HashConverter;
import org.fcrepo.kernel.modeshape.identifiers.NamespaceConverter;
import org.fcrepo.kernel.modeshape.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.modeshape.utils.FedoraTypesUtils;
import org.fcrepo.kernel.modeshape.utils.NamespaceTools;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;

public class HttpResourceConverter
extends IdentifierConverter<Resource, FedoraResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceConverter.class);
    private static final Pattern FORWARD_COMPONENT_PATTERN = Pattern.compile(".*?(/fcr:metadata)?(/fcr:versions(/\\d{14})?)?(/fcr:acl)?(\\#\\w+)?$");
    protected List<Converter<String, String>> translationChain;
    private final FedoraSession session;
    private final UriBuilder uriBuilder;
    protected Converter<String, String> forward = HttpResourceConverter.identity();
    protected Converter<String, String> reverse = HttpResourceConverter.identity();
    private final UriTemplate uriTemplate;
    private final boolean batch;
    private static final List<Converter<String, String>> minimalTranslationChain = ImmutableList.of((Object)new NamespaceConverter(), (Object)new HashConverter());

    public HttpResourceConverter(HttpSession session, UriBuilder uriBuilder) {
        this.session = session.getFedoraSession();
        this.uriBuilder = uriBuilder;
        this.batch = session.isBatchSession();
        this.uriTemplate = new UriTemplate(uriBuilder.toTemplate());
        this.resetTranslationChain();
    }

    private UriBuilder uriBuilder() {
        return UriBuilder.fromUri((String)this.uriBuilder.toTemplate());
    }

    protected FedoraResource doForward(Resource resource) {
        HashMap<String, String> values = new HashMap<String, String>();
        String path = this.asString(resource, values);
        Session jcrSession = FedoraSessionImpl.getJcrSession((FedoraSession)this.session);
        try {
            if (path != null) {
                Node node = this.getNode(path);
                boolean metadata = values.containsKey("path") && ((String)values.get("path")).contains("/fcr:metadata");
                FedoraResource fedoraResource = (FedoraResource)NodeResourceConverter.nodeConverter.convert((Object)node);
                if (!metadata && fedoraResource instanceof NonRdfSourceDescription) {
                    return fedoraResource.getDescribedResource();
                }
                return fedoraResource;
            }
            throw new IdentifierConversionException("Asked to translate a resource " + resource + " that doesn't match the URI template");
        }
        catch (RepositoryException e) {
            NamespaceTools.validatePath((Session)jcrSession, (String)path);
            if (e instanceof PathNotFoundException) {
                try {
                    Node preexistingNode = FedoraTypesUtils.getClosestExistingAncestor((Session)jcrSession, (String)path);
                    if (TombstoneImpl.hasMixin((Node)preexistingNode)) {
                        throw new TombstoneException((FedoraResource)new TombstoneImpl(preexistingNode));
                    }
                }
                catch (RepositoryException inner) {
                    LOGGER.debug("Error checking for parent tombstones", (Throwable)inner);
                }
            }
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    protected Resource doBackward(FedoraResource resource) {
        return this.toDomain(this.doBackwardPathOnly(resource));
    }

    public boolean inDomain(Resource resource) {
        HashMap values = new HashMap();
        return this.uriTemplate.match((CharSequence)resource.getURI(), values) && values.containsKey("path") || this.isRootWithoutTrailingSlash(resource);
    }

    public Resource toDomain(String path) {
        String realPath = path == null ? "" : (path.startsWith("/") ? path.substring(1) : path);
        UriBuilder uri = this.uriBuilder();
        if (realPath.contains("#")) {
            String[] split = realPath.split("#", 2);
            uri.resolveTemplate("path", (Object)split[0], false);
            uri.fragment(split[1]);
        } else {
            uri.resolveTemplate("path", (Object)realPath, false);
        }
        return ResourceFactory.createResource((String)uri.build(new Object[0]).toString());
    }

    public String asString(Resource resource) {
        HashMap<String, String> values = new HashMap<String, String>();
        return this.asString(resource, values);
    }

    private String asString(Resource resource, Map<String, String> values) {
        if (this.uriTemplate.match((CharSequence)resource.getURI(), values) && values.containsKey("path")) {
            String path = "/" + values.get("path");
            Matcher matcher = FORWARD_COMPONENT_PATTERN.matcher(path);
            if (matcher.matches()) {
                boolean webacAcl;
                boolean metadata = matcher.group(1) != null;
                boolean versioning = matcher.group(2) != null;
                boolean bl = webacAcl = matcher.group(4) != null;
                if (versioning) {
                    path = StringUtils.replaceOnce((String)path, (String)"/fcr:versions", (String)"/fedora:timemap");
                }
                if (metadata) {
                    path = StringUtils.replaceOnce((String)path, (String)"/fcr:metadata", (String)"/fedora:description");
                }
                if (webacAcl) {
                    path = StringUtils.replaceOnce((String)path, (String)"/fcr:acl", (String)"/fedora:acl");
                }
            }
            if ((path = (String)this.forward.convert((Object)path)) == null) {
                return null;
            }
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.debug("Unable to URL-decode path " + e + " as UTF-8", (Throwable)e);
            }
            if (path.isEmpty()) {
                return "/";
            }
            if (path.contains("//")) {
                throw new InvalidResourceIdentifierException("Path contains empty element! " + path);
            }
            return path;
        }
        if (this.isRootWithoutTrailingSlash(resource)) {
            return "/";
        }
        return null;
    }

    private Node getNode(String path) throws RepositoryException {
        try {
            return FedoraSessionImpl.getJcrSession((FedoraSession)this.session).getNode(path);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidResourceIdentifierException("Illegal path: " + path);
        }
    }

    private String doBackwardPathOnly(FedoraResource resource) {
        String path = (String)this.reverse.convert((Object)resource.getPath());
        if (path == null) {
            throw new RepositoryRuntimeException("Unable to process reverse chain for resource " + resource);
        }
        return HttpResourceConverter.convertToExternalPath(path);
    }

    public static String convertToExternalPath(String path) {
        String newPath = StringUtils.replaceOnce((String)path, (String)"/fedora:acl", (String)"/fcr:acl");
        newPath = StringUtils.replaceOnce((String)newPath, (String)"/fedora:timemap", (String)"/fcr:versions");
        newPath = StringUtils.replaceOnce((String)newPath, (String)"/fedora:description", (String)"/fcr:metadata");
        return newPath;
    }

    protected void resetTranslationChain() {
        if (this.translationChain == null) {
            this.translationChain = this.getTranslationChain();
            ArrayList<Converter<String, String>> newChain = new ArrayList<Converter<String, String>>(Collections.singleton(new TransactionIdentifierConverter(this.session, this.batch)));
            newChain.addAll(this.translationChain);
            this.setTranslationChain(newChain);
        }
    }

    private void setTranslationChain(List<Converter<String, String>> chained) {
        this.translationChain = chained;
        for (Converter<String, String> converter : this.translationChain) {
            this.forward = this.forward.andThen(converter);
        }
        for (Converter converter : Lists.reverse(this.translationChain)) {
            this.reverse = this.reverse.andThen(converter.reverse());
        }
    }

    protected List<Converter<String, String>> getTranslationChain() {
        ApplicationContext context = this.getApplicationContext();
        if (context != null) {
            List tchain = (List)this.getApplicationContext().getBean("translationChain", List.class);
            return tchain;
        }
        return minimalTranslationChain;
    }

    protected ApplicationContext getApplicationContext() {
        return ContextLoader.getCurrentWebApplicationContext();
    }

    private boolean isRootWithoutTrailingSlash(Resource resource) {
        HashMap values = new HashMap();
        return this.uriTemplate.match((CharSequence)(resource.getURI() + "/"), values) && values.containsKey("path") && ((String)values.get("path")).isEmpty();
    }

    static class TransactionIdentifierConverter
    extends Converter<String, String> {
        public static final String TX_PREFIX = "tx:";
        private final FedoraSession session;
        private final boolean batch;

        public TransactionIdentifierConverter(FedoraSession session, boolean batch) {
            this.session = session;
            this.batch = batch;
        }

        protected String doForward(String path) {
            if (path.contains(TX_PREFIX) && !path.contains(this.txSegment())) {
                throw new RepositoryRuntimeException("Path " + path + " is not in current transaction " + this.session.getId());
            }
            return StringUtils.replaceOnce((String)path, (String)this.txSegment(), (String)"");
        }

        protected String doBackward(String path) {
            return this.txSegment() + path;
        }

        private String txSegment() {
            return this.batch ? "/tx:" + this.session.getId() : "";
        }
    }
}

