/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.session.HttpSession;
import org.fcrepo.http.commons.session.SessionFactory;
import org.glassfish.hk2.api.Factory;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@RequestScoped
public class SessionProvider
implements Factory<HttpSession> {
    @Inject
    private SessionFactory sessionFactory;
    private final HttpServletRequest request;
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionProvider.class);

    @Inject
    public SessionProvider(HttpServletRequest request) {
        this.request = request;
    }

    public HttpSession provide() {
        HttpSession session = this.sessionFactory.getSession(this.request);
        LOGGER.trace("Providing new session {}", (Object)session);
        return session;
    }

    public void dispose(HttpSession session) {
        LOGGER.trace("Disposing session {}", (Object)session);
        session.expire();
    }
}

