/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import com.google.common.base.Throwables;
import javax.jcr.Credentials;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.http.commons.session.HttpSession;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.api.FedoraRepository;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.exception.SessionMissingException;
import org.fcrepo.kernel.api.services.BatchService;
import org.fcrepo.kernel.api.services.CredentialsService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SessionFactoryTest {
    private SessionFactory testObj;
    @Mock
    private FedoraSession mockSession;
    @Mock
    private FedoraRepository mockRepo;
    @Mock
    private BatchService mockTxService;
    @Mock
    private CredentialsService mockCredService;
    @Mock
    private FedoraSession mockTx;
    @Mock
    private HttpServletRequest mockRequest;

    @Before
    public void setUp() {
        this.testObj = new SessionFactory(this.mockRepo, this.mockTxService);
        TestHelpers.setField(this.testObj, "credentialsService", this.mockCredService);
        this.testObj.init();
    }

    @Test
    public void testGetSessionWithNullPath() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn(null);
        Mockito.when((Object)this.mockRequest.getContextPath()).thenReturn((Object)"");
        Mockito.when((Object)this.mockRepo.login(ArgumentMatchers.any(Credentials.class))).thenReturn((Object)this.mockSession);
        this.testObj.getSession(this.mockRequest);
        ((FedoraRepository)Mockito.verify((Object)this.mockRepo)).login(ArgumentMatchers.isNull());
    }

    @Test
    public void testGetSessionUnauthenticated() {
        this.testObj.getInternalSession();
        ((FedoraRepository)Mockito.verify((Object)this.mockRepo)).login();
    }

    @Test
    public void testCreateSession() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/some/path");
        this.testObj.createSession(this.mockRequest);
        ((FedoraRepository)Mockito.verify((Object)this.mockRepo)).login(ArgumentMatchers.isNull());
    }

    @Test
    public void testGetSessionFromTransaction() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Mockito.when((Object)this.mockTxService.getSession("123", null)).thenReturn((Object)this.mockTx);
        HttpSession session = this.testObj.getSessionFromTransaction(this.mockRequest, "123");
        Assert.assertEquals((Object)this.mockTx, (Object)session.getFedoraSession());
    }

    @Test
    public void testGetSessionThrowException() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Mockito.when((Object)this.mockTxService.getSession("123", null)).thenThrow(new Throwable[]{new SessionMissingException("")});
        try {
            this.testObj.getSession(this.mockRequest);
        }
        catch (RuntimeException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            Assert.assertTrue((String)"TransactionMissionException expected", (boolean)(rootCause instanceof SessionMissingException));
        }
    }

    @Test
    public void testGetEmbeddedIdTx() {
        Mockito.when((Object)this.mockRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        String txId = this.testObj.getEmbeddedId(this.mockRequest, SessionFactory.Prefix.TX);
        Assert.assertEquals((String)"txId should be 123", (Object)"123", (Object)txId);
    }
}

